@php
    $isFullSlots = $event->booked_seats >= $event->seats;
    $isClosedBooking = $event->booking_closed_at && \Carbon\Carbon::now()->lessThan($event->booking_closed_at);
@endphp

<div class="container">
    <div class="row mb-3">
        <div class="col-12">
            <h1> {{ $event->name }}</h1>
            <div class="text-muted">{{ __('Start on: :date', ['date' => $event->started_at->format('D, M d, Y')]) }}</div>
        </div>
    </div>
    <div class="row mb-3">
        <div class="col-lg-8">
            <div class="mb-3">
                {{ RvMedia::image($event->image, $event->name, attributes: ['class' => 'mw-100']) }}
            </div>

            <div class="row">
                {!! BaseHelper::clean($event->content) !!}
            </div>
        </div>

        <div class="col-lg-4">
            <div class="card bg-white">
                <div class="card-header">
                    <div class="card-title">
                        {{ __('Event Information')  }}
                    </div>
                </div>
                <div class="card-body p-0">
                    <ul class="list-group" style="border-radius: 0">
                        @if($organizer = $event->organizer)
                            <li class="list-group-item border-0">
                                {{ __('Organizer') }} : <strong>{{ $organizer->name }}</strong>
                            </li>
                        @endif

                        @if($address = $event->address)
                            <li class="list-group-item border-0">
                                {{ __('Address') }} : <strong>{{ $address }}</strong>
                            </li>
                        @endif

                        <li class="list-group-item border-0">
                            {{ __('Start date') }} : <strong>{{ $event->started_at }}</strong>
                        </li>

                        <li class="list-group-item border-0" style="border: none">
                            {{ __('Slots') }} : <strong>{{ $event->booked_seats }}</strong> /  <strong>{{ $event->seats }}</strong>

                            @if ($isFullSlots)
                                <span>( {{ __('Full') }} )</span>
                            @endif
                        </li>

                        <li class="list-group-item border-0" style="border: none">
                            {{ __('Status') }} : {{ $event->status->toHtml() }}
                        </li>
                    </ul>
                </div>
                <div class="card-footer">
                    <form action="{{ route('public.booking') }}" method="POST">
                        @csrf

                        <input type="hidden" name="event_id" value="{{ $event->getkey() }}">
                        <div class="form-group mb-3">
                            <label class="form-label" for="events-booking-number-slots">{{ __('Number Slots') }}</label>
                            <input
                                id="events-booking-number-slots"
                                class="form-control"
                                type="number"
                                name="number_slots"
                                value="1"
                                @disabled($isFullSlots || $isClosedBooking)
                            >
                        </div>

                        <button
                            type="submit"
                            class="w-100 btn btn-primary btn-block"
                            @disabled($isFullSlots || $isClosedBooking)
                        >
                            {{ __('Book Now') }}
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
