@extends(BaseHelper::getAdminMasterLayoutTemplate())

@section('content')
    @php
        do_action(BASE_ACTION_TOP_FORM_CONTENT_NOTIFICATION, request(), $ticket);
    @endphp

    <x-core::form method="post">
        <div class="row">
            <div class="col-md-9">
                <x-core::card>
                    <x-core::card.header>
                        <h4 class="card-title">{{ trans('plugins/events-booking::events-booking.ticket.ticket_information') }}</h4>

                        <div class="card-actions">
                            {!! apply_filters('order-information-card-actions', null, $ticket) !!}
                        </div>
                    </x-core::card.header>

                    <x-core::card.body>
                        <x-core::datagrid>
                            @if($order = $ticket->order)
                                <x-core::datagrid.item>
                                    <x-slot:title>{{ trans('plugins/events-booking::events-booking.ticket.order_code') }}</x-slot:title>
                                    {{ $order->code }}
                                </x-core::datagrid.item>
                            @endif


                            <x-core::datagrid.item>
                                <x-slot:title>{{ trans('plugins/events-booking::events-booking.ticket.code') }}</x-slot:title>
                                {{ $ticket->code }}
                            </x-core::datagrid.item>

                            @if ($name = $ticket->name)
                                <x-core::datagrid.item>
                                    <x-slot:title>{{ trans('plugins/events-booking::events-booking.ticket.ticket_name') }}</x-slot:title>
                                    {{ $name }}
                                </x-core::datagrid.item>
                            @endif

                            @if ($email = $ticket->email)
                                <x-core::datagrid.item>
                                    <x-slot:title>{{ trans('plugins/events-booking::events-booking.ticket.email') }}</x-slot:title>
                                    {{ $email }}
                                </x-core::datagrid.item>
                            @endif

                            @if ($phone = $ticket->phone)
                                <x-core::datagrid.item>
                                    <x-slot:title>{{ trans('plugins/events-booking::events-booking.ticket.phone') }}</x-slot:title>
                                    {{ $phone }}
                                </x-core::datagrid.item>
                            @endif

                            <x-core::datagrid.item>
                                <x-slot:title>{{ trans('plugins/events-booking::events-booking.ticket.status') }}</x-slot:title>
                                {!! BaseHelper::clean($ticket->status->toHtml()) !!}
                            </x-core::datagrid.item>
                        </x-core::datagrid>

                        @if ($ticket->status->getValue() !== 'pending')
                            <div class="row mt-3 ">
                                <div class="mb-1"><strong>{{ trans('plugins/events-booking::events-booking.ticket.qr_code') }}</strong></div>
                                <div class="col-lg-4 w-auto">
                                    {{ RvMedia::image($ticket->qr_code_image, $ticket->name, attributes: ['class' => 'border border-1', 'width' => 120, 'height' => 120]) }}
                                </div>
                            </div>
                        @endif
                    </x-core::card.body>
                </x-core::card>

                @php
                    do_action(BASE_ACTION_META_BOXES, 'advanced', $ticket);
                @endphp
            </div>

            <div class="col-md-3">
                @include('core/base::forms.partials.form-actions', [
                    'title' => trans('plugins/events-booking::events-booking.order.action'),
                ])

                <x-core::card class="meta-boxes mt-3">
                    <x-core::card.header>
                        <h4 class="card-title">
                            <label class="form-label required" for="status">
                                {{ trans('core/base::tables.status') }}
                            </label>
                        </h4>
                    </x-core::card.header>

                    <x-core::card.body>
                        {!! Form::customSelect('status', $ticketStatuses, $ticket->status) !!}
                    </x-core::card.body>
                </x-core::card>

                @php
                    do_action(BASE_ACTION_META_BOXES, 'side', $ticket);
                @endphp
            </div>
        </div>
    </x-core::form>
@endsection
