<?php

namespace ArchiElite\EventsBooking\Enums;

use Botble\Base\Facades\BaseHelper;
use Botble\Base\Supports\Enum;
use Illuminate\Support\HtmlString;

/**
 * @method static AccountStatusEnum ACTIVATED()
 * @method static AccountStatusEnum LOCKED()
 */
class AccountStatusEnum extends Enum
{
    public const ACTIVATED = 'activated';

    public const LOCKED = 'locked';

    public static $langPath = 'plugins/events-booking::events-booking.enums.accounts.statuses';

    public function toHtml(): HtmlString|string
    {
        $color = match ($this->value) {
            self::ACTIVATED => 'success',
            self::LOCKED => 'warning',
            default => 'primary',
        };

        return BaseHelper::renderBadge($this->label(), $color);
    }
}
