<?php

namespace ArchiElite\EventsBooking\Enums;

use Botble\Base\Facades\Html;
use Botble\Base\Supports\Enum;
use Illuminate\Support\HtmlString;

/**
 * @method static AccountTypeEnum ATTENDEE()
 * @method static AccountTypeEnum SPEAKER()
 * @method static AccountTypeEnum ORGANIZER()
 */
class AccountTypeEnum extends Enum
{
    public const ATTENDEE = 'attendee';

    public const SPEAKER = 'speaker';

    public const ORGANIZER = 'organizer';

    public static $langPath = 'plugins/events-booking::events-booking.enums.accounts.types';

    public function toHtml(): string|HtmlString
    {
        return match ($this->value) {
            self::ATTENDEE => Html::tag('span', self::ATTENDEE()->label(), ['class' => 'badge bg-info text-info-fg']),
            self::SPEAKER => Html::tag('span', self::SPEAKER()->label(), ['class' => 'badge bg-info text-info-fg']),
            self::ORGANIZER => Html::tag('span', self::ORGANIZER()->label(), ['class' => 'badge bg-info text-info-fg']),
            default => parent::toHtml(),
        };
    }
}
