<?php

namespace ArchiElite\EventsBooking\Facades;

use ArchiElite\EventsBooking\Supports\InvoiceHelper as InvoiceSupport;
use Illuminate\Support\Facades\Facade;

/**
 * @method static array supportedDateFormats()
 * @method static string|null getCompanyCountry()
 * @method static string|null getCompanyState()
 * @method static string|null getCompanyCity()
 * @method static string|null getCompanyZipCode()
 * @method static string getLanguageSupport()
 * @method static string getInvoiceTemplate()
 * @method static array getVariables()
 * @method static string getInvoiceTemplateCustomizedPath()
 * @method static \ArchiElite\EventsBooking\Models\Invoice getDataForPreview()
 * @method static \ArchiElite\EventsBooking\Models\Invoice store(\ArchiElite\EventsBooking\Models\Order $order)
 * @method static \Illuminate\Http\Response streamInvoice(\ArchiElite\EventsBooking\Models\Invoice $invoice)
 * @method static \Illuminate\Http\Response downloadInvoice(\ArchiElite\EventsBooking\Models\Invoice $invoice)
 *
 * @see \ArchiElite\EventsBooking\Supports\InvoiceSupport
 */
class InvoiceHelper extends Facade
{
    protected static function getFacadeAccessor(): string
    {
        return InvoiceSupport::class;
    }
}
