<?php

namespace ArchiElite\EventsBooking\Facades;

use ArchiElite\EventsBooking\Supports\OrderHelper as OrderHelperSupport;
use Illuminate\Support\Facades\Facade;

/**
 * @method static bool sendOrderConfirmationEmail(\ArchiElite\EventsBooking\Models\Order $order)
 * @method static bool sendOrderCompletedEmail(\ArchiElite\EventsBooking\Models\Order $order)
 * @method static bool confirmPayment(\ArchiElite\EventsBooking\Models\Order $order)
 *
 * @see \ArchiElite\EventsBooking\Supports\OrderHelperSupport
 */
class OrderHelper extends Facade
{
    protected static function getFacadeAccessor(): string
    {
        return OrderHelperSupport::class;
    }
}
