<?php

namespace ArchiElite\EventsBooking\Forms;

use ArchiElite\EventsBooking\Enums\AccountStatusEnum;
use ArchiElite\EventsBooking\Enums\AccountTypeEnum;
use ArchiElite\EventsBooking\Http\Requests\AccountRequest;
use ArchiElite\EventsBooking\Models\Account;
use Botble\Base\Forms\FieldOptions\DatePickerFieldOption;
use Botble\Base\Forms\FieldOptions\EmailFieldOption;
use Botble\Base\Forms\FieldOptions\OnOffFieldOption;
use Botble\Base\Forms\FieldOptions\SelectFieldOption;
use Botble\Base\Forms\FieldOptions\StatusFieldOption;
use Botble\Base\Forms\FieldOptions\TextFieldOption;
use Botble\Base\Forms\Fields\DatePickerField;
use Botble\Base\Forms\Fields\MediaImageField;
use Botble\Base\Forms\Fields\OnOffField;
use Botble\Base\Forms\Fields\SelectField;
use Botble\Base\Forms\Fields\TextField;
use Botble\Base\Forms\FormAbstract;

class AccountForm extends FormAbstract
{
    public function setup(): void
    {
        $this
            ->model(Account::class)
            ->setValidatorClass(AccountRequest::class)
            ->withCustomFields()
            ->columns()
            ->add(
                'name',
                TextField::class,
                TextFieldOption::make()
                    ->label(trans('plugins/events-booking::events-booking.account.form.name'))
                    ->required()
                    ->maxLength(120)
                    ->colspan(2)
                    ->toArray()
            )
            ->add(
                'email',
                TextField::class,
                EmailFieldOption::make()
                    ->required()
                    ->colspan(1)
                    ->toArray()
            )
            ->add(
                'phone',
                TextField::class,
                TextFieldOption::make()
                    ->label(trans('plugins/events-booking::events-booking.account.form.phone'))
                    ->placeholder(trans('plugins/events-booking::events-booking.account.form.phone_placeholder'))
                    ->maxLength(15)
                    ->colspan(1)
            )
            ->add(
                'dob',
                DatePickerField::class,
                DatePickerFieldOption::make()
                    ->defaultValue(null)
                    ->label(trans('plugins/events-booking::events-booking.account.form.dob'))
                    ->colspan(2)
            )
            ->when($this->getModel()->getKey(), function (AccountForm $form) {
                $form->add(
                    'is_change_password',
                    OnOffField::class,
                    OnOffFieldOption::make()
                        ->label(trans('plugins/events-booking::events-booking.account.form.change_password'))
                        ->defaultValue(0)
                        ->colspan(2)
                );
            })
            ->add(
                'password',
                'password',
                TextFieldOption::make()
                    ->label(trans('plugins/events-booking::events-booking.account.form.password'))
                    ->collapsible('is_change_password', 1, ! $this->getModel()->exists || $this->getModel()->is_change_password)
                    ->required()
                    ->maxLength(60)
                    ->colspan(1)
            )
            ->add(
                'password_confirmation',
                'password',
                TextFieldOption::make()
                    ->label(trans('plugins/events-booking::events-booking.account.form.password_confirmation'))
                    ->collapsible('is_change_password', 1, ! $this->getModel()->exists || $this->getModel()->is_change_password)
                    ->required()
                    ->maxLength(60)
                    ->colspan(1)
            )
            ->add('status', SelectField::class, StatusFieldOption::make()->choices(AccountStatusEnum::labels())->toArray())
            ->add(
                'type',
                SelectField::class,
                SelectFieldOption::make()
                    ->label(trans('plugins/events-booking::events-booking.account.form.type'))
                    ->required()
                    ->choices(AccountTypeEnum::labels())
            )
            ->add('avatar', MediaImageField::class)
            ->setBreakFieldPoint('status');
    }
}
