<?php

namespace ArchiElite\EventsBooking\Http\Controllers\Accounts;

use ArchiElite\EventsBooking\Models\Order;
use Botble\Base\Http\Controllers\BaseController;
use Botble\SeoHelper\Facades\SeoHelper;
use Botble\Theme\Facades\Theme;

class OrderController extends BaseController
{
    public function __construct()
    {
        Theme::asset()
            ->add('account-style', 'vendor/core/plugins/events-booking/css/account.css', ['bootstrap-css']);
        Theme::asset()
            ->container('footer')
            ->add('front-theme-js', 'vendor/core/plugins/events-booking/js/front-theme.js', ['bootstrap-js']);
    }

    public function index()
    {
        SeoHelper::setTitle(__('Orders'));

        $orders = Order::query()
            ->where([
                'account_id' => auth('account')->id(),
            ])
            ->withCount(['event', 'tickets'])
            ->orderByDesc('created_at')
            ->paginate(10);

        Theme::breadcrumb()
            ->add(__('Orders'), route('account.orders'));

        return Theme::scope(
            'events-booking.accounts.orders.list',
            compact('orders'),
            'plugins/events-booking::themes.accounts.orders.list'
        )->render();
    }

    public function show(string|int $id)
    {
        $order = Order::query()
            ->where([
                'id' => $id,
                'account_id' => auth('account')->id(),
            ])
            ->with(['event', 'tickets'])
            ->firstOrFail();

        SeoHelper::setTitle(__('Order detail :id', ['id' => $order->code]));

        Theme::breadcrumb()
            ->add(
                __('Order detail :id', ['id' => $order->code]),
                route('account.orders.show', $id)
            );

        return Theme::scope(
            'events-booking.accounts.orders.show',
            compact('order'),
            'plugins/events-booking::themes.accounts.orders.show'
        )->render();
    }
}
