<?php

namespace ArchiElite\EventsBooking\Http\Controllers\Accounts;

use ArchiElite\EventsBooking\Enums\OrderStatusEnum;
use ArchiElite\EventsBooking\Models\Ticket;
use Botble\Base\Http\Controllers\BaseController;
use Botble\SeoHelper\Facades\SeoHelper;
use Botble\Theme\Facades\Theme;
use Illuminate\Http\Request;

class TicketController extends BaseController
{
    public function __construct()
    {
        Theme::asset()
            ->add('account-style', 'vendor/core/plugins/events-booking/css/account.css', ['bootstrap-css']);
    }

    public function show(string $orderId, string $ticketId, Request $request)
    {
        $account = $request->user('account');

        $ticket = Ticket::query()
            ->whereHas('order', function ($query) use ($account) {
                $query
                    ->where('status', OrderStatusEnum::COMPLETED)
                    ->where('account_id', $account->id);
            })
            ->where('id', $ticketId)
            ->where('order_id', $orderId)
            ->first();

        if (! $ticket) {
            abort(404);
        }

        SeoHelper::setTitle(__('Ticket #:code', ['code' => $ticket->code]));

        Theme::breadcrumb()
            ->add(
                __('Ticket #:code', ['code' => $ticket->code]),
                route('account.tickets.show', ['order' => $orderId, 'ticket' => $ticketId])
            );

        return $this
            ->httpResponse()
            ->setData(view('plugins/events-booking::themes.accounts.tickets.show', compact('ticket'))->render());
    }
}
