<?php

namespace ArchiElite\EventsBooking\Http\Controllers;

use ArchiElite\EventsBooking\Facades\EventsBookingHelper;
use ArchiElite\EventsBooking\Tables\RecentBookingTable;
use Botble\Base\Facades\Assets;
use Botble\Base\Http\Controllers\BaseController;
use Botble\Base\Widgets\AdminWidget;
use Illuminate\Http\Request;

class BookingReportController extends BaseController
{
    public function __construct()
    {
        $this
            ->breadcrumb()
            ->add(trans('plugins/events-booking::events-booking.name'));
    }

    public function index(Request $request, AdminWidget $widget)
    {
        $this->pageTitle(trans('plugins/events-booking::events-booking.booking.reports'));

        Assets::addScriptsDirectly([
            'vendor/core/plugins/events-booking/libraries/daterangepicker/daterangepicker.js',
            'vendor/core/plugins/events-booking/js/report.js',
        ])
            ->addStylesDirectly([
                'vendor/core/plugins/events-booking/libraries/daterangepicker/daterangepicker.css',
                'vendor/core/plugins/events-booking/css/report.css',
            ])
            ->addScripts(['moment']);

        Assets::usingVueJS();

        [$startDate, $endDate] = EventsBookingHelper::getDateRangeInReport($request);

        if ($request->ajax()) {
            return $this
                ->httpResponse()->setData(view('plugins/events-booking::reports.ajax', compact('widget'))->render());
        }

        return view(
            'plugins/events-booking::reports.index',
            compact('startDate', 'endDate', 'widget')
        );
    }

    public function getRecentBookings(RecentBookingTable $table)
    {
        return $table->renderTable();
    }
}
