<?php

namespace ArchiElite\EventsBooking\Http\Controllers\Settings;

use ArchiElite\Events\Http\Requests\Settings\InvoiceTemplateSettingRequest;
use ArchiElite\EventsBooking\Facades\InvoiceHelper;
use Botble\Base\Facades\Assets;
use Botble\Base\Facades\BaseHelper;
use Illuminate\Contracts\View\View;
use Illuminate\Support\Facades\File;

class InvoiceTemplateSettingController extends SettingController
{
    public function edit(): View
    {
        $this->pageTitle(trans('plugins/events-booking::settings.invoice_templates.title'));

        Assets::addScriptsDirectly('vendor/core/core/setting/js/email-template.js');

        $content = InvoiceHelper::getInvoiceTemplate();
        $variables = InvoiceHelper::getVariables();

        return view('plugins/events-booking::invoice-template.settings', compact('content', 'variables'));
    }

    public function update(InvoiceTemplateSettingRequest $request)
    {
        $filePath = InvoiceHelper::getInvoiceTemplateCustomizedPath();

        File::ensureDirectoryExists(File::dirname($filePath));

        BaseHelper::saveFileData($filePath, $request->input('content'), false);

        return $this
            ->httpResponse()
            ->withUpdatedSuccessMessage();
    }

    public function reset()
    {
        File::delete(InvoiceHelper::getInvoiceTemplateCustomizedPath());

        return $this
            ->httpResponse()
            ->setMessage(trans('plugins/events-booking::invoice-template.reset_success'));
    }

    public function preview()
    {
        $invoice = InvoiceHelper::getDataForPreview();

        return InvoiceHelper::streamInvoice($invoice);
    }
}
