<?php

namespace ArchiElite\EventsBooking\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class RedirectIfAccount
{
    public function handle(Request $request, Closure $next, string $guard = 'account')
    {
        if (Auth::guard($guard)->check()) {
            return redirect(route('account.overview'));
        }

        return $next($request);
    }
}
