<?php

namespace ArchiElite\EventsBooking\Http\Middleware;

use ArchiElite\EventsBooking\Enums\AccountStatusEnum;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class RedirectIfNotAccount
{
    public function handle(Request $request, Closure $next, string $guard = 'account')
    {
        if (! Auth::guard($guard)->check()) {
            if ($request->ajax() || $request->wantsJson()) {
                return response('Unauthorized.', 401);
            }

            return redirect()->guest(route('account.login'));
        }

        $customer = Auth::guard($guard)->user();
        if ($customer->status->getValue() !== AccountStatusEnum::ACTIVATED) {
            Auth::guard($guard)->logout();

            return redirect()
                ->guest(route('account.login'))
                ->withErrors([
                    'email' => [
                        __('Your account has been locked, please contact the administrator.'),
                    ],
                ])
                ->withInput(['email' => $customer->email]);
        }

        return $next($request);
    }
}
