<?php

namespace ArchiElite\EventsBooking\Http\Requests;

use Botble\Base\Facades\BaseHelper;
use Botble\Support\Http\Requests\Request;

class CheckoutRequest extends Request
{
    public function rules(): array
    {
        return [
            'event_id' => ['required', 'exists:eb_events,id'],
            'name' => ['required', 'string', 'max:120'],
            'email' => ['required', 'email', 'max:120'],
            'phone' => ['nullable', ...explode('|', BaseHelper::getPhoneValidationRule())],
            'note' => ['nullable', 'string', 'max:1000'],
            'terms_conditions' => ['accepted:1'],
            'tickets' => ['required', 'array'],
            'tickets.*.name' => ['required', 'string', 'max:120'],
            'tickets.*.email' => ['required', 'email', 'max:120'],
            'tickets.*.phone' => ['nullable', ...explode('|', BaseHelper::getPhoneValidationRule())],
            'tickets.*.note' => ['nullable', 'string', 'max:1000'],
            'register_account' => ['nullable'],
            'password' => ['nullable', 'required_if:register_account,1', 'min:6'],
            'password_confirm' => ['nullable', 'required_if:register_account,1', 'same:password'],
        ];
    }

    public function attributes(): array
    {
        return [
            'tickets' => __('Tickets'),
            'tickets.*.name' => __('Ticket Name'),
            'tickets.*.email' => __('Ticket Email'),
            'tickets.*.phone' => __('Ticket Phone'),
            'tickets.*.note' => __('Ticket Note'),
        ];
    }
}
