<?php

namespace ArchiElite\EventsBooking\Http\Requests;

use ArchiElite\EventsBooking\Models\Event;
use Botble\Support\Http\Requests\Request;

class InitBookingRequest extends Request
{
    public function rules(): array
    {
        $event = Event::query()->findOrFail($this->input('event_id'));

        return [
            'event_id' => ['required', 'exists:eb_events,id'],
            'number_slots' => ['required', 'numeric', 'min:1', 'max:' . ($event->seats - $event->booked_seats)],
        ];
    }
}
