<?php

namespace ArchiElite\EventsBooking\Listeners;

use ArchiElite\EventsBooking\Enums\InvoiceStatusEnum;
use ArchiElite\EventsBooking\Enums\TicketStatusEnum;
use ArchiElite\EventsBooking\Events\OrderCompleted;
use ArchiElite\EventsBooking\Facades\InvoiceHelper;
use ArchiElite\EventsBooking\Facades\OrderHelper;
use ArchiElite\EventsBooking\Models\Invoice;
use ArchiElite\EventsBooking\Models\Order;
use Carbon\Carbon;
use Illuminate\Contracts\Queue\ShouldQueue;

class OrderCompletedListener implements ShouldQueue
{
    public function handle(OrderCompleted $orderCompleted): void
    {
        $order = $orderCompleted->order;

        $order->update([
            'completed_at' => Carbon::now(),
        ]);

        $order->loadMissing(['event', 'invoice']);

        $order->tickets()->update([
            'status' => TicketStatusEnum::PURCHASED,
        ]);

        $invoice =  $order->invoice;

        if (! $invoice) {
            InvoiceHelper::store($order);
        }

        $invoice = Invoice::query()
            ->where('reference_type', Order::class)
            ->where('reference_id', $order->id)
            ->first();

        $invoice->update([
            'status' => InvoiceStatusEnum::COMPLETED,
        ]);

        OrderHelper::sendOrderCompletedEmail($order);
    }
}
