<?php

namespace ArchiElite\EventsBooking\Listeners;

use ArchiElite\EventsBooking\Widgets\BookingCard;
use ArchiElite\EventsBooking\Widgets\BookingChart;
use ArchiElite\EventsBooking\Widgets\CustomerCard;
use ArchiElite\EventsBooking\Widgets\CustomerChart;
use ArchiElite\EventsBooking\Widgets\RecentBookingsTable;
use ArchiElite\EventsBooking\Widgets\RevenueCard;
use ArchiElite\EventsBooking\Widgets\TicketCard;
use Botble\Base\Events\RenderingAdminWidgetEvent;

class RegisterBookingReportsWidget
{
    public function handle(RenderingAdminWidgetEvent $event): void
    {
        $event->widget->register([
            RevenueCard::class,
            TicketCard::class,
            CustomerCard::class,
            BookingCard::class,
            CustomerChart::class,
            BookingChart::class,
            RecentBookingsTable::class,
        ], 'booking-reports');
    }
}
