<?php

namespace ArchiElite\EventsBooking\Models;

use ArchiElite\EventsBooking\Enums\TicketStatusEnum;
use ArchiElite\EventsBooking\Facades\TicketHelper;
use Botble\Base\Models\BaseModel;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Ticket extends BaseModel
{
    protected $table = 'eb_tickets';

    protected $fillable = [
        'order_id',
        'code',
        'name',
        'email',
        'phone',
        'note',
        'checked_in_at',
        'status',
    ];

    protected $casts = [
        'checked_in_at' => 'datetime',
        'status' => TicketStatusEnum::class,
    ];

    protected $appends = [
        'qr_code_image',
    ];

    public function order(): BelongsTo
    {
        return $this->belongsTo(Order::class, 'order_id');
    }

    public function qrCodeImage(): Attribute
    {
        return Attribute::get(fn () => TicketHelper::getQrCodeImage($this));
    }
}
