<?php

namespace ArchiElite\EventsBooking\PanelSections;

use Botble\Base\PanelSections\PanelSection;
use Botble\Base\PanelSections\PanelSectionItem;

class SettingEventsBookingPanelSection extends PanelSection
{
    public function setup(): void
    {
        $this
            ->setId('settings.events_booking')
            ->setTitle(trans('plugins/events-booking::settings.name'))
            ->withPriority(1000)
            ->addItems([
                PanelSectionItem::make('settings.events_booking.currency_settings')
                    ->setTitle(trans('plugins/events-booking::settings.currency.title'))
                    ->withIcon('ti ti-coin')
                    ->withDescription(trans('plugins/events-booking::settings.currency.description'))
                    ->withPriority(1)
                    ->withRoute('events-booking.settings.currencies'),
                PanelSectionItem::make('settings.events_booking.account_settings')
                    ->setTitle(trans('plugins/events-booking::settings.account.title'))
                    ->withIcon('ti ti-users')
                    ->withDescription(trans('plugins/events-booking::settings.account.description'))
                    ->withPriority(2)
                    ->withRoute('events-booking.settings.accounts'),
                PanelSectionItem::make('settings.events_booking.invoice_settings')
                    ->setTitle(trans('plugins/events-booking::settings.invoice.title'))
                    ->withIcon('ti ti-file-invoice')
                    ->withDescription(trans('plugins/events-booking::settings.invoice.description'))
                    ->withPriority(3)
                    ->withRoute('events-booking.settings.invoices'),
                PanelSectionItem::make('settings.events-booking.invoice_template_settings')
                    ->setTitle(trans('plugins/events-booking::invoice-template.name'))
                    ->withIcon('ti ti-list-details')
                    ->withDescription(trans('plugins/events-booking::invoice-template.setting_description'))
                    ->withPriority(120)
                    ->withRoute('events-booking.settings.invoice-template'),
            ]);
    }
}
