<?php

namespace ArchiElite\EventsBooking\Providers;

use ArchiElite\EventsBooking\Events\OrderCompleted;
use ArchiElite\EventsBooking\Events\OrderCreated;
use ArchiElite\EventsBooking\Events\OrderPaymentConfirmedEvent;
use ArchiElite\EventsBooking\Events\TicketResendMailEvent;
use ArchiElite\EventsBooking\Listeners\GenerateInvoiceListener;
use ArchiElite\EventsBooking\Listeners\OrderCompletedListener;
use ArchiElite\EventsBooking\Listeners\OrderCreatedNotification;
use ArchiElite\EventsBooking\Listeners\OrderPaymentConfirmedNotification;
use ArchiElite\EventsBooking\Listeners\RegisterBookingReportsWidget;
use ArchiElite\EventsBooking\Listeners\TicketResendMailListener;
use ArchiElite\EventsBooking\Listeners\SendTicketEmailListener;
use ArchiElite\EventsBooking\Listeners\UpdateAttendeesListener;
use ArchiElite\EventsBooking\Models\Order;
use Botble\Base\Events\RenderingAdminWidgetEvent;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;

class EventServiceProvider extends ServiceProvider
{
    protected $listen = [
        OrderCreated::class => [
            GenerateInvoiceListener::class,
            OrderCreatedNotification::class,
        ],
        OrderCompleted::class => [
            UpdateAttendeesListener::class,
            OrderCompletedListener::class,
            SendTicketEmailListener::class,
        ],
        OrderPaymentConfirmedEvent::class => [
            OrderPaymentConfirmedNotification::class,
        ],
        RenderingAdminWidgetEvent::class => [
            RegisterBookingReportsWidget::class,
        ],
        TicketResendMailEvent::class => [
            TicketResendMailListener::class,
        ]
    ];

    public function boot(): void
    {
        Order::updated(function (Order $order) {
            if ($order->wasChanged('status') && $order->isCompleted() && $order->completed_at === null) {
                event(new OrderCompleted($order));
            }
        });
    }
}
