<?php

namespace ArchiElite\EventsBooking\Services;

use Endroid\QrCode\Builder\Builder;
use Endroid\QrCode\Writer\PngWriter;
use Endroid\QrCode\Writer\Result\ResultInterface;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;

class QrCodeService
{
    protected function build(string $data): ResultInterface
    {
        File::ensureDirectoryExists(Storage::path('qrcode'));

        return Builder::create()
            ->writer(new PngWriter())
            ->data($data)
            ->build();
    }

    public function saveToFile(string $data, string $filename): void
    {
        $this->build($data)->saveToFile(Storage::path($filename));
    }

    public function toDataUri(string $data): string
    {
        return $this->build($data)->getDataUri();
    }
}
