<?php

namespace ArchiElite\EventsBooking\Tables;

use ArchiElite\EventsBooking\Models\Ticket;
use Botble\Table\Abstracts\TableAbstract;
use Botble\Table\Actions\EditAction;
use Botble\Table\BulkActions\DeleteBulkAction;
use Botble\Table\BulkChanges\CreatedAtBulkChange;
use Botble\Table\Columns\Column;
use Botble\Table\Columns\CreatedAtColumn;
use Botble\Table\Columns\FormattedColumn;
use Botble\Table\Columns\IdColumn;
use Botble\Table\Columns\LinkableColumn;
use Botble\Table\Columns\StatusColumn;
use Illuminate\Database\Eloquent\Builder;

class TicketTable extends TableAbstract
{
    public function setup(): void
    {
        $this
            ->model(Ticket::class)
            ->addActions([
                EditAction::make()->route('events-booking.tickets.edit'),
            ])
            ->addColumns([
                IdColumn::make(),
                LinkableColumn::make('order_id')
                    ->urlUsing(function (LinkableColumn $column) {
                        $ticket = $column->getItem();

                        if (! $ticket->order_id) {
                            return null;
                        }

                        return route('events-booking.orders.edit', $ticket->order_id);
                    })
                    ->label(trans('plugins/events-booking::events-booking.ticket.order_code'))
                    ->getValueUsing(function (FormattedColumn $column) {
                        $item = $column->getItem();
                        $item->loadMissing('order');

                        if (! $order = $item->order) {
                            return '-';
                        }

                        return $order->code;
                    }),
                Column::make('code')
                    ->label(trans('plugins/events-booking::events-booking.ticket.code')),
                Column::make('name')
                    ->label(trans('plugins/events-booking::events-booking.ticket.account_name')),
                StatusColumn::make(),
                CreatedAtColumn::make(),
            ])
            ->addBulkChanges([
                CreatedAtBulkChange::make(),
            ])
            ->addBulkActions([
                DeleteBulkAction::make()->permission('events-booking.tickets.destroy'),
            ])
            ->queryUsing(function (Builder $query) {
                $query->select([
                    'id',
                    'order_id',
                    'name',
                    'code',
                    'status',
                    'created_at',
                ]);
            });
    }
}
