let mix = require('laravel-mix');

const path = require('path');
let directory = path.basename(path.resolve(__dirname));

const source = 'platform/plugins/' + directory;
const dist = 'public/vendor/core/plugins/' + directory;

mix
    .js(source + '/resources/assets/js/currencies.js', dist + '/js')
    .js(source + '/resources/assets/js/checkout.js', dist + '/js')
    .js(source + '/resources/assets/js/order.js', dist + '/js')
    .js(source + '/resources/assets/js/report.js', dist + '/js')
    .js(source + '/resources/assets/js/front-theme.js', dist + '/js')
    .js(source + '/resources/assets/js/coupon.js', dist + '/js')
    .js(source + '/resources/assets/js/export-attendees.js', dist + '/js')
    .copy(dist + '/js/currencies.js', source + '/public/js')
    .copy(dist + '/js/checkout.js', source + '/public/js')
    .copy(dist + '/js/order.js', source + '/public/js')
    .copy(dist + '/js/report.js', source + '/public/js')
    .copy(dist + '/js/front-theme.js', source + '/public/js')
    .copy(dist + '/js/coupon.js', source + '/public/js')
    .copy(dist + '/js/export-attendees.js', source + '/public/js')

const styles = [
    'front-events-booking.scss',
    'front-auth.scss',
    'account.scss',
];

styles.forEach(item => {
    mix.sass(source + '/resources/assets/sass/' + item, dist + '/css');
});

if (mix.inProduction()) {
    styles.forEach(item => {
        mix.copy(dist + '/css/' + item.replace('.scss', '.css'), source + '/public/css');
    });
}
