<?php

namespace Botble\Note;

use Botble\Base\Contracts\BaseModel;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class Note
{
    public function registerModule(array|string $model): self
    {
        if (! is_array($model)) {
            $model = [$model];
        }

        config([
            'plugins.note.general.supported' => array_merge(config('plugins.note.general.supported', []), $model),
        ]);

        return $this;
    }

    public function saveNote(Request $request, Model|null|bool $object): void
    {
        if (in_array(get_class($object), config('plugins.note.general.supported', [])) && $request->input('note')) {
            $note = new Models\Note();
            $note->note = $request->input('note');
            $note->user_id = Auth::guard()->id();
            $note->created_by = Auth::guard()->id();
            $note->reference_type = get_class($object);
            $note->reference_id = $object->getKey();
            $note->save();
        }
    }

    public function deleteNote(Model|null|bool $data): bool
    {
        if ($data instanceof BaseModel) {
            Models\Note::query()
                ->where([
                    'reference_id' => $data->getKey(),
                    'reference_type' => get_class($data),
                ])->delete();

            return true;
        }

        return false;
    }
}
