@php
    $bgColor = $shortcode->background_color;
    $textColor = $shortcode->text_color;
    $bgImage = $shortcode->background_image ? RvMedia::getImageUrl($shortcode->background_image) : null;

    $variablesStyle = [];

    if ($textColor && $textColor !== 'transparent') {
        $variablesStyle["--shortcode-text-color: $textColor"] = $textColor;
    }
    if ($bgColor !== 'transparent') {
        $variablesStyle["--shortcode-background-color: $bgColor"] = $bgColor;
    }
    if ($bgImage) {
        $variablesStyle["--shortcode-background-image: url($bgImage)"] = $bgImage;
    }

    $primaryButtonLabel = $shortcode->primary_button_label;
    $primaryButtonUrl = $shortcode->primary_button_url;

    $secondaryButtonLabel = $shortcode->secondary_button_label;
    $secondaryButtonUrl = $shortcode->secondary_button_url;

    $title = $shortcode->title;
    $subtitle = $shortcode->subtitle;

    $addSpacing = ($title || $subtitle) && ($primaryButtonLabel && $primaryButtonUrl) || ($secondaryButtonLabel && $secondaryButtonUrl);
@endphp

@if($startDate = $shortcode->start_date)
    <div @class(['shortcode-countdown others5-section-area', 'sp7' => $addSpacing]) @style($variablesStyle)>
        <div class="container timer timer-single"
             data-target="{{ \Carbon\Carbon::make($startDate)->format('m-d-Y h:m:i') }}">
            @if($title || $subtitle)
                <div class="row">
                    <div class="col-lg-9 m-auto">
                        <div class="heading8 text-center space-margin80">
                            @if($subtitle)
                                <h5>
                                    @if($subtitleImage = $shortcode->subtitle_image)
                                        {{ RvMedia::image($subtitleImage, '') }}
                                    @endif
                                    {!! BaseHelper::clean($subtitle) !!}
                                </h5>
                            @endif

                            @if ($title)
                                <div class="space32"></div>
                                <h2>{!! BaseHelper::clean($title) !!}</h2>
                            @endif
                        </div>
                    </div>
                </div>
            @endif

            <div class="row">
                <div class="col-lg-3 col-md-6">
                    <div class="cta-counter-box">
                        <img src="{{ Theme::asset()->url('images/shapes/elements23.png') }}" alt=""
                             class="elements23 keyframe5" />
                        <h2><span class="time-value days"></span></h2>
                    </div>
                    <div class="space50 d-lg-none d-block"></div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="cta-counter-box">
                        <img src="{{ Theme::asset()->url('images/shapes/elements23.png') }}" alt=""
                             class="elements23 keyframe5" />
                        <h2><span class="time-value hours"></span></h2>
                    </div>
                    <div class="space50 d-lg-none d-block"></div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="cta-counter-box">
                        <img src="{{ Theme::asset()->url('images/shapes/elements23.png') }}" alt=""
                             class="elements23 keyframe5" />
                        <h2><span class="time-value minutes"></span></h2>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="cta-counter-box">
                        <img src="{{ Theme::asset()->url('images/shapes/elements23.png') }}" alt=""
                             class="elements23 keyframe5" />
                        <h2><span class="time-value seconds"></span></h2>
                    </div>
                </div>
            </div>

            @if(($primaryButtonLabel && $primaryButtonUrl) || ($secondaryButtonLabel && $secondaryButtonUrl))
                <div class="row">
                    <div class="col-lg-12 m-auto">
                        <div class="space60"></div>
                        <div class="btn-area1 text-center">
                            @if($primaryButtonLabel && $primaryButtonUrl)
                                <a href="{{ $primaryButtonUrl }}" class="vl-btn5">
                                    <span class="demo">{!! BaseHelper::clean($primaryButtonLabel) !!}</span>
                                    <span class="arrow"><x-core::icon name="ti ti-arrow-right"/></span>
                                </a>
                            @endif

                            @if($secondaryButtonLabel && $secondaryButtonUrl)
                                <a href="{{ $secondaryButtonUrl }}" class="vl-btn5 btn2">
                                    <span class="demo">{!! BaseHelper::clean($secondaryButtonLabel) !!}</span>
                                </a>
                            @endif
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>
@endif
