'use strict'

$(document).ready(function () {
    const $shortcodeEventsSchedule = $('.shortcode-events-schedule')
    $shortcodeEventsSchedule.on('click', '[data-bb-toggle="events-schedule"]', function () {
        const $current = $(this)
        const currentDate = $current.attr('data-date')

        initEventsSchedule(currentDate)
    })

    if ($shortcodeEventsSchedule.length) {
        $shortcodeEventsSchedule.find('[data-bb-toggle="events-schedule"]').first().trigger('click')
    }

    /**
     * Improve SEO Index
     */
    $('.owl-nav button').attr('aria-label', 'Owl button')
    $('.owl-nav button').removeAttr('type')
    $('.owl-nav button').removeAttr('role')
    $('.testimonial-boxarea .slick-slide .slick-current .slick-active').removeAttr('aria-hidden')

    EventifySearch()

    const checkOutForm = $('.payment-checkout-form')
    const input = checkOutForm.find('input')
    const textarea = checkOutForm.find('textarea')
    handleFocusBlur(input)
    handleFocusBlur(textarea)

    const $bookingForm = $('.booking-information')

    $(document).on('click', '[data-bb-toggle="fill-in-information"]', function (event) {
        event.preventDefault()

        const $currentTarget = $(this)

        const email = $bookingForm.find('input[name="email"]').val()
        const name = $bookingForm.find('input[name="name"]').val()
        const phone = $bookingForm.find('input[name="phone"]').val()

        const $ticketForm = $currentTarget.closest('.ticket-form')
        const $ticketNumber = $ticketForm.attr('data-bb-value')

        if (email) {
            $ticketForm.find(`input[name="tickets[${$ticketNumber}][email]"]`).val(email).focus()
        }

        if (name) {
            $ticketForm.find(`input[name="tickets[${$ticketNumber}][name]"]`).val(name).focus()
        }

        if (phone) {
            $ticketForm.find(`input[name="tickets[${$ticketNumber}][phone]"]`).val(phone).focus()
        }
    })

    const $announcementContainer = $('.ae-anno-announcement-wrapper')
    const $announcementData = $('[data-bb-toggle="announcement"]')

    if ($announcementContainer.length && $announcementData.length) {
        setTimeout(() => {
            getHeightAnnouncement()
        }, 500)

        $announcementContainer.on('click',  '.ae-anno-announcement__arrow, .ae-anno-announcement__dismiss-button', function() {
            getHeightAnnouncement()
        })

        $(window).resize(function(){
            getHeightAnnouncement()
        })

        function getHeightAnnouncement() {
            const height = $announcementContainer.outerHeight() || 0

            console.log(height)

            $($announcementData.data('bb-target')).css('--height-announcement', height + 'px')
        }
    }
})

function initEventsSchedule(currentDate) {
    let index = 0
    $('[data-bb-value="events-schedule"]').each(function (e) {
        const currentScope = $(this)
        const date = currentScope.attr('data-date')
        currentScope.removeClass('active')

        if (date === currentDate) {
            index++
            currentScope.show()
            currentScope.addClass('active')
            currentScope.find('.ordinal-number').text(index)
        } else {
            currentScope.hide()
        }
    })

    if ($('.shortcode-events-schedule-style-2').length) {
        $('.homepage-2 [data-bb-value="events-schedule"].active')
            .last()
            .find('.event2-boxarea')
            .removeClass('box1')
            .addClass('box3')
    }
}

const EventifySearch = function () {
    const form = $('.header-search-container form.search-form')
    const searchInput = $('.header-search-container form.search-form input[name="q"]')
    const url = form.data('ajax-url')
    const searchResultsEle = $('.search-results')
    const noDataHtml = $('.header-search-container form.search-form .no-data')

    searchInput.on('input', function () {
        if ($(this).val().length >= 3) {
            searchResultsEle.css('opacity', '0.5')
            $.ajax({
                url: url,
                data: {
                    q: $(this).val(),
                },
                success: function (response) {
                    searchResultsEle.css('opacity', '1')
                    if (!response.error) {
                        searchResultsEle.addClass('active')
                        searchResultsEle.html(response.data)
                    } else {
                        searchResultsEle.html(noDataHtml)
                    }
                },
            })
        }
    })

    searchInput.on('blur', function () {
        searchResultsEle.removeClass('active')
    })
    searchInput.on('focus', function () {
        searchResultsEle.addClass('active')
    })
}

function isValidInput(element) {
    return element.val().trim() !== '' // Adjust this condition if needed (e.g., regex validation)
}

function handleFocusBlur(element) {
    element.on('focus', function () {
        $(this).parent().addClass('input-focus')
    })

    element.on('blur', function () {
        if (!isValidInput($(this))) {
            $(this).parent().removeClass('input-focus')
        }
    })

    // Ensure the class is added if there's already a valid value on page load
    element.each(function () {
        if (isValidInput($(this))) {
            $(this).parent().addClass('input-focus')
        }
    })
}
