<?php

use Botble\Base\Forms\FieldOptions\ColorFieldOption;
use Botble\Base\Forms\FieldOptions\MediaImageFieldOption;
use Botble\Base\Forms\FieldOptions\SelectFieldOption;
use Botble\Base\Forms\FieldOptions\TextFieldOption;
use Botble\Base\Forms\FieldOptions\UiSelectorFieldOption;
use Botble\Base\Forms\Fields\ColorField;
use Botble\Base\Forms\Fields\MediaImageField;
use Botble\Base\Forms\Fields\NumberField;
use Botble\Base\Forms\Fields\SelectField;
use Botble\Base\Forms\Fields\TextField;
use Botble\Base\Forms\Fields\UiSelectorField;
use Botble\Blog\Models\Post;
use Botble\Shortcode\Compilers\Shortcode as ShortcodeCompiler;
use Botble\Shortcode\Facades\Shortcode;
use Botble\Shortcode\Forms\ShortcodeForm;
use Botble\Theme\Facades\Theme;
use Illuminate\Routing\Events\RouteMatched;
use Illuminate\Support\Arr;

if (! is_plugin_active('blog')) {
    return;
}

app('events')->listen(RouteMatched::class, function (): void {

    Shortcode::register('blog-posts', __('Blog posts'), __('Blog posts'), function (ShortcodeCompiler $shortcode): ?string {
        $categoryIds = Shortcode::fields()->getIds('category_ids', $shortcode);
        $limit = (int) $shortcode->limit ?? 3;
        $type = $shortcode->type ?: 'latest';

        $posts = Post::query()
            ->wherePublished()
            ->with(['slugable', 'categories.slugable'])
            ->when(! empty($categoryIds), function ($query) use ($categoryIds): void {
                $query->whereHas('categories', function ($query) use ($categoryIds): void {
                    $query->whereIn('categories.id', $categoryIds);
                });
            })
            ->when($type !== '', function ($query) use ($type): void {
                switch ($type) {
                    case 'featured':
                        $query->where('is_featured', true);

                        break;
                    case 'popular':
                        $query->orderBy('views', 'desc');

                        break;
                    default:
                        $query->orderBy('created_at', 'desc');

                        break;
                }
            })
            ->limit($limit)
            ->get();

        return Theme::partial('shortcodes.blog-posts.index', compact('shortcode', 'posts'));
    });

    Shortcode::modifyAdminConfig('blog-posts', function (ShortcodeForm $form) {
        $type = [
            'latest' => __('Latest'),
            'featured' => __('Featured'),
            'popular' => __('Popular'),
        ];

        $attributes = $form->getModel();

        $form
            ->remove('paginate')
            ->addBefore(
                'paginate',
                'style',
                UiSelectorField::class,
                UiSelectorFieldOption::make()
                    ->withoutAspectRatio()
                    ->numberItemsPerRow(1)
                    ->selected(Arr::get($attributes, 'style', 1))
                    ->choices(collect(range(1, 3))->mapWithKeys(function ($i) {
                        return [
                            $i => [
                                'label' => __('Style :i', ['i' => $i]),
                                'image' => Theme::asset()->url("images/shortcodes/blog-posts/style-$i.png"),
                            ],
                        ];
                    })->all())
            )
            ->add('limit', NumberField::class, [
                'label' => __('Limit'),
            ])
            ->add(
                'title',
                TextField::class,
                TextFieldOption::make()
                    ->label(__('Title'))
            )
            ->add(
                'subtitle',
                TextField::class,
                TextFieldOption::make()
                    ->collapsible('style', [1, 2], $attributes['style'] ?? 1)
                    ->label(__('Subtitle'))
            )
            ->add(
                'type',
                SelectField::class,
                SelectFieldOption::make()
                    ->choices($type)
                    ->label(__('Choose type'))
            )
            ->add(
                'text_color',
                ColorField::class,
                ColorFieldOption::make()
                    ->label(__('Text color'))
            )
            ->add(
                'background_color',
                ColorField::class,
                ColorFieldOption::make()
                    ->label(__('Background color'))
            )
            ->add(
                'background_image',
                MediaImageField::class,
                MediaImageFieldOption::make()
                    ->label(__('Background image'))
            );

        return $form;
    });
});
