<?php

use Botble\Base\Forms\FieldOptions\ColorFieldOption;
use Botble\Base\Forms\FieldOptions\MediaImageFieldOption;
use Botble\Base\Forms\FieldOptions\SelectFieldOption;
use Botble\Base\Forms\FieldOptions\TextFieldOption;
use Botble\Base\Forms\FieldOptions\UiSelectorFieldOption;
use Botble\Base\Forms\Fields\ColorField;
use Botble\Base\Forms\Fields\MediaImageField;
use Botble\Base\Forms\Fields\SelectField;
use Botble\Base\Forms\Fields\TextField;
use Botble\Base\Forms\Fields\UiSelectorField;
use Botble\Shortcode\Compilers\Shortcode as ShortcodeCompiler;
use Botble\Shortcode\Facades\Shortcode;
use Botble\Shortcode\Forms\ShortcodeForm;
use Botble\Testimonial\Models\Testimonial;
use Botble\Theme\Facades\Theme;
use Illuminate\Support\Arr;

if (!is_plugin_active('testimonial')) {
    return;
}

Shortcode::register('testimonials', __('Testimonials'), __('Add testimonials'), function (ShortcodeCompiler $shortcode): ?string {
    if (!($testimonialIds = Shortcode::fields()->getIds('testimonial_ids', $shortcode))) {
        return null;
    }

    $testimonials = Testimonial::query()
        ->with('metadata')
        ->whereIn('id', $testimonialIds)
        ->wherePublished()
        ->get();

    if ($testimonials->isEmpty()) {
        return null;
    }

    return Theme::partial('shortcodes.testimonials.index', compact('shortcode', 'testimonials'));
});

Shortcode::setAdminConfig('testimonials', function (array $attributes) {
    $testimonials = Testimonial::query()
        ->wherePublished()
        ->pluck('name', 'id')
        ->all();

    return ShortcodeForm::createFromArray($attributes)
        ->withLazyLoading()
        ->add(
            'style',
            UiSelectorField::class,
            UiSelectorFieldOption::make()
                ->choices(collect(range(1, 4))->mapWithKeys(function ($i) {
                    return [
                        $i => [
                            'label' => __('Style :i', ['i' => $i]),
                            'image' => Theme::asset()->url("images/shortcodes/testimonials/style-$i.png"),
                        ],
                    ];
                })->all())
                ->selected(Arr::get($attributes, 'style', 1))
                ->withoutAspectRatio()
                ->numberItemsPerRow(1)
                ->toArray()
        )
        ->add(
            'title',
            TextField::class,
            TextFieldOption::make()
                ->label(__('Title'))
                ->toArray()
        )
        ->add(
            'subtitle_image',
            MediaImageField::class,
            MediaImageFieldOption::make()
                ->collapsible('style', 3, $attributes['style'] ?? 1)
                ->label(__('Subtitle image'))
        )
        ->add(
            'subtitle',
            TextField::class,
            TextFieldOption::make()
                ->collapsible('style', [1, 2, 3], $attributes['style'] ?? 1)
                ->label(__('Subtitle'))
                ->toArray()
        )
        ->add(
            'testimonial_ids',
            SelectField::class,
            SelectFieldOption::make()
                ->choices($testimonials)
                ->selected(explode(',', Arr::get($attributes, 'testimonial_ids')))
                ->searchable()
                ->multiple()
                ->label(__('Choose testimonials'))
                ->toArray()
        )
        ->add(
            'youtube_video_url',
            TextField::class,
            TextFieldOption::make()
                ->label(__('Youtube video URL'))
                ->collapsible('style', 1, $attributes['style'] ?? 1)
                ->collapsible('style', 1, $attributes['style'] ?? 1)
        )
        ->add(
            'image',
            MediaImageField::class,
            MediaImageFieldOption::make()
                ->label(__('Image'))
                ->collapsible('style', 1, $attributes['style'] ?? 1)
                ->collapsible('style', 1, $attributes['style'] ?? 1)
        )
        ->add(
            'background_color',
            ColorField::class,
            ColorFieldOption::make()
                ->label(__('Background color'))
        );
});
