<?php

use Botble\Theme\ThemeOption;
use Botble\Theme\ThemeOption\Fields\ColorField;
use Botble\Theme\ThemeOption\Fields\MediaImageField;
use Botble\Theme\ThemeOption\Fields\MultiCheckListField;
use Botble\Theme\ThemeOption\Fields\NumberField;
use Botble\Theme\ThemeOption\Fields\SelectField;
use Botble\Theme\ThemeOption\Fields\TextField;
use Botble\Theme\ThemeOption\Fields\ToggleField;

app()->booted(function () {
    theme_option()
        ->setField([
            'id' => 'copyright',
            'section_id' => 'opt-text-subsection-general',
            'type' => 'text',
            'label' => __('Copyright'),
            'attributes' => [
                'name' => 'copyright',
                'value' => __('© :year Your Company. All right reserved.', ['year' => now()->format('Y')]),
                'options' => [
                    'class' => 'form-control',
                    'placeholder' => __('Change copyright'),
                    'data-counter' => 250,
                ],
            ],
            'helper' => __('Copyright on footer of site'),
        ])
        ->setField([
            'id' => 'primary_color',
            'section_id' => 'opt-text-subsection-general',
            'type' => 'customColor',
            'label' => __('Primary color'),
            'attributes' => [
                'name' => 'primary_color',
                'value' => '#ff2b4a',
            ],
        ])
        ->setField(
            MediaImageField::make()
                ->sectionId('opt-text-subsection-general')
                ->id('preloader_image')
                ->name('preloader_image')
                ->label(__('Preloader image'))
        )
        ->setSection([
            'title' => __('Header'),
            'id' => 'opt-text-subsection-header',
            'subsection' => true,
            'icon' => 'ti ti-layout-navbar',
            'fields' => [
                ToggleField::make()
                    ->label(__('Display header top?'))
                    ->id('display_header_top')
                    ->defaultValue(false)
                    ->name('display_header_top'),
                ColorField::make()
                    ->label(__('Header top text color'))
                    ->id('header_top_text_color')
                    ->name('header_top_text_color'),
                ColorField::make()
                    ->label(__('Header top background color'))
                    ->id('header_top_background_color')
                    ->name('header_top_background_color'),
                ColorField::make()
                    ->label(__('Header text color'))
                    ->id('header_text_color')
                    ->name('header_text_color'),
                ColorField::make()
                    ->label(__('Header background color'))
                    ->id('header_background_color')
                    ->name('header_background_color'),
                ToggleField::make()
                    ->label(__('Header transparent?'))
                    ->name('is_header_transparent')
                    ->helperText('When this feature is enabled, the header will have a transparent background and will float to the top of the page.'),
            ],
        ])
        ->setSection([
            'title' => __('Footer'),
            'id' => 'opt-text-subsection-footer',
            'subsection' => true,
            'icon' => 'ti ti-layout-bottombar',
            'fields' => [
                ColorField::make()
                    ->name('footer_background_color')
                    ->label(__('Background color')),
                MediaImageField::make()
                    ->name('footer_background_image')
                    ->label(__('Background image')),
                ColorField::make()
                    ->name('footer_heading_color')
                    ->label(__('Text heading color')),
                ColorField::make()
                    ->name('footer_text_color')
                    ->label(__('Text color')),
            ],
        ])
        ->setSection([
            'title' => __('Styles'),
            'id' => 'opt-text-subsection-styles',
            'subsection' => true,
            'icon' => 'ti ti-brush',
            'fields' => [
                ColorField::make()
                    ->name('primary_color')
                    ->value('#FFBA00')
                    ->label(__('Primary color')),
                ColorField::make()
                    ->name('secondary_color')
                    ->value('#1A1719')
                    ->label(__('Secondary color')),
                ColorField::make()
                    ->name('heading_color')
                    ->value('#1A1719')
                    ->label(__('Heading color')),
                ColorField::make()
                    ->name('text_color')
                    ->value('#544E51')
                    ->label(__('Text color')),
                MediaImageField::make()
                    ->name('body_background_image')
                    ->label(__('Body background image')),
            ],
        ])
        ->setField(
            ColorField::make()
                ->sectionId('opt-text-subsection-breadcrumb')
                ->id('breadcrumb_background_color')
                ->name('breadcrumb_background_color')
                ->value('')
                ->label(__('Breadcrumb background color'))
        )
        ->setField(
            ColorField::make()
                ->sectionId('opt-text-subsection-breadcrumb')
                ->id('breadcrumb_text_color')
                ->name('breadcrumb_text_color')
                ->value('transparent')
                ->label(__('Breadcrumb text color'))
        )
        ->setField(
            MediaImageField::make()
                ->sectionId('opt-text-subsection-breadcrumb')
                ->id('breadcrumb_background_image')
                ->name('breadcrumb_background_image')
                ->label(__('Breadcrumb background image'))
        )
        ->setField(
            NumberField::make()
                ->sectionId('opt-text-subsection-breadcrumb')
                ->id('breadcrumb_height')
                ->name('breadcrumb_height')
                ->label(__('Breadcrumb height (px)'))
                ->helperText(__('Leave empty to use default height.'))
        )
        ->when(is_plugin_active('blog'), function (ThemeOption $option) {
            return $option
                ->setField([
                    'id' => 'blog_post_meta_display',
                    'section_id' => 'opt-text-subsection-blog',
                    'type' => 'multiChecklist',
                    'label' => __('Post meta display (blog list)'),
                    'attributes' => [
                        'name' => 'blog_post_meta_display[]',
                        'value' => json_decode(theme_option('blog_post_meta_display', '["published_date"]')) ?: [],
                        'choices' => [
                            'author_name' => __('Author name'),
                            'published_date' => __('Published date'),
                            'view_count' => __('View count'),
                        ],
                    ],
                ])->setField([
                    'id' => 'blog_post_detail_meta_display',
                    'section_id' => 'opt-text-subsection-blog',
                    'type' => 'multiChecklist',
                    'label' => __('Post meta display (blog detail)'),
                    'attributes' => [
                        'name' => 'blog_post_detail_meta_display[]',
                        'value' => json_decode(theme_option('blog_post_detail_meta_display', '["published_date"]')) ?: [],
                        'choices' => [
                            'author_name' => __('Author name'),
                            'published_date' => __('Published date'),
                            'view_count' => __('View count'),
                            'reading_time' => __('Reading time'),
                            'category' => __('Category'),
                        ],
                    ],
                ])
                ->setField([
                    'id' => 'blog_post_items_per_row',
                    'section_id' => 'opt-text-subsection-blog',
                    'type' => 'customSelect',
                    'label' => __('Blog post grid items per row'),
                    'comment' => 'Some thing',
                    'attributes' => [
                        'name' => 'post_items_per_row',
                        'list' => [
                            1 => __(':number Posts', ['number' => 1]),
                            2 => __(':number Posts', ['number' => 2]),
                            3 => __(':number Posts', ['number' => 3]),
                            4 => __(':number Posts', ['number' => 4]),
                        ],
                    ], 'helper' => __('Only apply for grid style'),

                ])
                ->setField(
                    NumberField::make()
                        ->sectionId('opt-text-subsection-blog')
                        ->id('number_of_related_posts')
                        ->name('number_of_related_posts')
                        ->label(__('Number of related posts'))
                        ->value(3)
                )
                ->setField(
                    MediaImageField::make()
                        ->sectionId('opt-text-subsection-blog')
                        ->id('calender_icon_image')
                        ->name('calender_icon_image')
                        ->label(__('Calender icon image'))
                )
                ->setField(
                    MediaImageField::make()
                        ->sectionId('opt-text-subsection-blog')
                        ->id('author_icon_image')
                        ->name('author_icon_image')
                        ->label(__('Author icon image'))
                )->setField(
                    MediaImageField::make()
                        ->sectionId('opt-text-subsection-blog')
                        ->id('views_icon_image')
                        ->name('views_icon_image')
                        ->label(__('View icon image'))
                )->setField(
                    MediaImageField::make()
                        ->sectionId('opt-text-subsection-blog')
                        ->id('reading_time_icon_image')
                        ->name('reading_time_icon_image')
                        ->label(__('Reading time icon image'))
                )->setField(
                    MediaImageField::make()
                        ->sectionId('opt-text-subsection-blog')
                        ->id('category_icon_image')
                        ->name('category_icon_image')
                        ->label(__('Category icon image'))
                );
        })
        ->setSection([
            'title' => __('Events'),
            'id' => 'opt-text-subsection-events-booking',
            'subsection' => true,
            'icon' => 'ti ti-calendar-check',
            'fields' => [
                TextField::make()
                    ->name('event_list_title')
                    ->label(__('Event list title'))
                    ->priority(1),
                MultiCheckListField::make()
                    ->label(__('Event list meta display'))
                    ->name(__('event_list_meta_display'))
                    ->inline()
                    ->defaultValue(['date_time'])
                    ->options([
                        'organizer_name' => __('Organizer name'),
                        'organizer_title' => __('Organizer title'),
                        'organizer_image' => __('Organizer image'),
                        'date_time' => __('Date time'),
                        'address' => __('Address'),
                    ])
                    ->priority(2),
                MultiCheckListField::make()
                    ->label(__('Event detail meta display'))
                    ->name(__('event_detail_meta_display'))
                    ->inline()
                    ->defaultValue(['date_time', 'organizer_name', 'organizer_title', 'organizer_image'])
                    ->options([
                        'organizer_name' => __('Organizer name'),
                        'organizer_title' => __('Organizer title'),
                        'organizer_image' => __('Organizer image'),
                        'date_time' => __('Date time'),
                        'address' => __('Address'),
                    ])
                    ->priority(3),
                MultiCheckListField::make()
                    ->label(__('Event list widget meta display'))
                    ->name(__('event_list_widget_meta_display'))
                    ->inline()
                    ->defaultValue(['date_time', 'organizer_name', 'organizer_title', 'organizer_image'])
                    ->options([
                        'organizer_name' => __('Organizer name'),
                        'organizer_title' => __('Organizer title'),
                        'organizer_image' => __('Organizer image'),
                        'date_time' => __('Date time'),
                        'address' => __('Address'),
                    ])
                    ->priority(4),
                MediaImageField::make()
                    ->name('event_list_widget_date_icon_image')
                    ->label(__('Event list widget date icon image'))
                    ->priority(5),
            ],
        ])
        ->setSection([
            'title' => __('Search'),
            'id' => 'opt-text-subsection-search',
            'subsection' => true,
            'icon' => 'ti ti-search',
            'fields' => [
                SelectField::make()
                    ->name('home_search_type')
                    ->label(__('Home search type'))
                    ->options([
                        'events' => __('Events'),
                        'posts' => __('Posts'),
                    ])
                    ->defaultValue('events'),
                ColorField::make()
                    ->name('home_search_background_color')
                    ->label(__('Home search background color')),
                ColorField::make()
                    ->name('home_search_text_color')
                    ->label(__('Home search text color')),
                ColorField::make()
                    ->name('home_search_hover_color')
                    ->label(__('Home search hover color')),
                MediaImageField::make()
                    ->name('home_search_icon_image')
                    ->label(__('Home search icon image')),
            ],
        ]);
});
