@php
    $durationPattern = [800, 1000, 1200];
    $aosDuration = $durationPattern[$key % count($durationPattern)];
    $postMetaData = json_decode(theme_option('blog_post_meta_display', []), true);
    $shouldDisplayDateTime = in_array('published_date', $postMetaData);
    $shouldDisplayAuthor = in_array('author_name', $postMetaData);
    $shouldDisplayView = in_array('view_count', $postMetaData);
@endphp

<div
    class="col-lg-4 col-md-6 aos-init post-item"
    data-aos="zoom-in"
    data-aos-duration="{{ $aosDuration }}"
>
    <div class="blog4-boxarea">
        @if ($image = $post->image)
            <div class="img1">
                {{ RvMedia::image($post->image, $post->name, 'medium-rectangle-vertical') }}
            </div>
        @endif
        <div class="content-area post-metadata">
            <ul>
                @if (($publishedDate = $post->created_at) && $shouldDisplayDateTime)
                    @php
                        $formatDate = new DateTime($publishedDate);
                    @endphp
                    <li>
                        <span>
                            @if ($calenderIcon = theme_option('calender_icon_image'))
                                {{ RvMedia::image($calenderIcon, 'calender icon') }}
                            @endif
                            {{ $formatDate->format('d M Y') }} <span class="symbol-slash"> | </span>
                        </span>
                    </li>
                @endif
                @if (($author = $post->author) && $shouldDisplayAuthor)
                    @php
                        $fullName = $author->first_name . ' ' . $author->last_name;
                    @endphp
                    <li>
                        <a
                            aria-label="{{ $fullName }}"
                            href="{{ $author->url }}"
                        >
                            @if ($authorIcon = theme_option('author_icon_image'))
                                {{ RvMedia::image($authorIcon, 'author icon') }}
                            @endif
                            {!! BaseHelper::clean($fullName) !!}
                            <span class="symbol-slash"> | </span>
                        </a>
                    </li>
                @endif
                @if (($views = $post->views) && $shouldDisplayView)
                    <li>
                        <span>
                            @if ($viewIcon = theme_option('views_icon_image'))
                                {{ RvMedia::image($viewIcon, 'view icon') }}
                            @endif
                            {!! BaseHelper::clean($views) !!}
                            <span class="symbol-slash"> | </span>
                        </span>

                    </li>
                @endif
            </ul>
            @if ($name = $post->name)
                <div class="space20"></div>
                <a
                    aria-label="{{ $name }}}"
                    class="truncate-2-custom"
                    title="{{ $name }}"
                    href="{{ $post->url }}"
                    title="{{ $name }}"
                >{{ $name }}</a>
            @endif
            <div class="space24"></div>
            <a
                aria-label="{{ $name }}}"
                href="{{ $post->url }}"
                class="readmore"
            >{{ __('Read now') }}
                <x-core::icon name="ti ti-arrow-right" />
            </a>
            <div class="arrow">
                <a
                    aria-label="{{ $name }}}"
                    href="{{ $post->url }}"
                ><x-core::icon name="ti ti-arrow-right" /></a>
            </div>
        </div>
    </div>
</div>
