@php
    $bgImage = Theme::get('breadcrumb_background_image') ?: theme_option('breadcrumb_background_image');
    $bgImage = $bgImage ? RvMedia::getImageUrl($bgImage) : null;

    $bgColor = Theme::get('breadcrumb_background_color');
    $bgColor = $bgColor && $bgColor !== 'transparent' ? $bgColor  : theme_option('breadcrumb_background_color');

    $textColor = Theme::get('breadcrumb_text_color');
    $textColor = $textColor && $textColor !== 'transparent' ? $textColor : theme_option('breadcrumb_text_color');

    $height = Theme::get('breadcrumb_height') ?: theme_option('breadcrumb_height');
    $height = (int) $height ? $height . 'px' : 'auto';
    $hasTextColor = $textColor && $textColor !== 'transparent';
@endphp

@if ($pageTitle = Theme::get('pageTitle'))
    <div class="breadcrumb__area inner-page-header"
        @style([
            '--breadcrumb-bg-color: ' . $bgColor => $bgColor,
            '--breadcrumb-bg-image: ' . "url('$bgImage')" => $bgImage,
            '--breadcrumb-txt-color: ' . $textColor => $hasTextColor,
            '--breadcrumb-height: ' . $height => $height,
        ])
    >
        <div class="container">
            <div class="row">
                <div class="" style="text-align: start;">
                    @if (Theme::breadcrumb()->enabled())
                        <div class="space20"></div>
                        @foreach (Theme::breadcrumb()->getCrumbs() as $crumb)
                            @if (! $loop->last)
                                <a class="breadcrumb-item" href="{{ $crumb['url'] }}" title="{{ $crumb['label'] }}">
                                    {{ $crumb['label'] }}
                                </a>

                                <x-core::icon name="ti ti-chevron-right" />
                            @else
                                <span class="breadcrumb-item active">{{ $crumb['label'] }}</span>
                            @endif
                        @endforeach
                    @endif
                    <h1>{!! BaseHelper::clean($pageTitle) !!}</h1>
                </div>
            </div>
        </div>
    </div>
@endif
