<div class="event2-boxarea box1">
    <h1 class="active">{{ $number }}</h1>
    <div class="row align-items-center">
        <div class="col-lg-6">
            <div class="content-area xxl-w-500">
                <ul>
                    @if ($shouldDisplayDateTime)
                        <li>
                            <span>
                                {{ $event->getEventTimeAttribute() }}
                            </span>
                            <span class="symbol-slash"> | </span>
                        </li>
                    @endif
                    @if ($shouldDisplayAddress)
                        <li>
                            <span>
                                {{ $event->address }}
                            </span>
                        </li>
                    @endif
                </ul>
                @if ($name = $event->name)
                    <div class="space20"></div>
                    <a
                        href="{{ $event->url }}"
                        class="head"
                    >{{ $name }}</a>
                @endif
                <div class="space24"></div>
                <div class="author-area">
                    @if ($speakers = $event->speakers->take(2))
                        @foreach ($speakers as $speaker)
                            <div class="autho-name-area border-none">
                                @if (($avatar = $speaker->avatar) && $shouldDisplayOrganizerImage)
                                    <div class="img1">
                                        {{ RvMedia::image($avatar, $speaker->name, 'thumb') }}
                                    </div>
                                @endif
                                <div class="text">
                                    @if (($name = $speaker->name) && $shouldDisplayOrganizerName)
                                        <a href="{{ $speaker->url }}">{{ $name }}</a>
                                    @endif
                                    @if (($title = $speaker->getMetaData('title', true)) && $shouldDisplayOrganizerTitle)
                                        <div class="space8"></div>
                                        <p>{!! BaseHelper::clean($title) !!}</p>
                                    @endif
                                </div>
                            </div>
                        @endforeach
                    @endif
                </div>
                <div class="space24"></div>
                <div class="btn-area1">
                    <a
                        href="{{ $event->url }}"
                        class="vl-btn1"
                    ><span class="demo">{{ __('purchase ticket Now') }}</span></a>
                </div>
            </div>
            <div class="space30 d-lg-none d-block"></div>
        </div>

        <div class="col-lg-5">
            @if ($image = $event->image)
                <div class="img1">
                    {{ RvMedia::image($image, $event->name ?? '', 'medium') }}
                </div>
            @endif
        </div>
    </div>
</div>
