@php
    $pillId = 'pills-faq-' . $categoryId;
    $ariaLabel = 'pills-faq-' . $categoryId . '-tab';
    $accordionStartId = 'accordion-start-' . $categoryId;
    $accordionEndId = 'accordion-end-' . $categoryId;

@endphp
<div
    class="tab-pane fade {{ $categoryId == 'all' ? 'active show' : '' }}"
    id={{ $pillId }}
    role="tabpanel"
    aria-labelledby={{ $ariaLabel }}
    tabindex="0"
>
    <div class="faq-section-area">
        <div class="row">
            <div class="col-lg-6">
                <div class="accordian-area">
                    <div
                        class="accordion"
                        id="{{ $accordionStartId }}"
                    >
                        @foreach ($dataStart as $faq)
                            @continue(!$faq['question'])

                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button
                                        class="accordion-button collapsed"
                                        type="button"
                                        data-bs-toggle="collapse"
                                        data-bs-target="#{{ $categoryId . '-' . $faq['id'] }}"
                                        aria-expanded="false"
                                        aria-controls="{{ $categoryId . '-' . $faq['id'] }}"
                                    >{{ $faq['question'] }}</button>
                                </h2>
                                <div
                                    id="{{ $categoryId . '-' . $faq['id'] }}"
                                    class="accordion-collapse collapse"
                                    data-bs-parent="#{{ $accordionStartId }}"
                                >
                                    @if ($faq['answer'])
                                        <div class="accordion-body">
                                            <p>{{ $faq['answer'] }}</p>
                                        </div>
                                    @endif
                                </div>
                            </div>
                            <div class="space20"></div>
                        @endforeach
                    </div>
                </div>
            </div>

            <div class="col-lg-6">
                <div class="accordian-area">
                    <div
                        class="accordion"
                        id="{{ $accordionEndId }}"
                    >
                        @foreach ($dataEnd as $faq)
                            @continue(!$faq['question'])
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button
                                        class="accordion-button collapsed"
                                        type="button"
                                        data-bs-toggle="collapse"
                                        data-bs-target="#{{ $categoryId . '-' . $faq['id'] }}"
                                        aria-expanded="false"
                                        aria-controls="{{ $categoryId . '-' . $faq['id'] }}"
                                    >{{ $faq['question'] }}</button>
                                </h2>
                                <div
                                    id="{{ $categoryId . '-' . $faq['id'] }}"
                                    class="accordion-collapse collapse"
                                    data-bs-parent="#{{ $accordionEndId }}"
                                >
                                    @if ($faq['answer'])
                                        <div class="accordion-body">
                                            <p>{{ $faq['answer'] }}</p>
                                        </div>
                                    @endif
                                </div>
                            </div>
                            <div class="space20"></div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
