@php
    $announcementDisplayHtml = apply_filters('announcement_display_html');
    $headerWrapperClass = $headerWrapperClass ?? null;
    $bgColor = theme_option('header_top_background_color');
    $textColor = theme_option('header_top_text_color');
@endphp

<div
    @class(['header-top menu-top-area', $headerWrapperClass])
    @style([
        "--header-top-background-color: $bgColor" => $bgColor,
        "--header-top-text-color: $textColor" => $textColor,
    ])
>
    <div class="container">
        <div class="d-flex flex-row-reverse">
            <div class="top-menu-area w-100 align-items-center">
                @if ($announcementDisplayHtml)
                    {!! $announcementDisplayHtml !!}
                @endif

                {!! dynamic_sidebar('header_top_sidebar') !!}

                <div class="d-flex align-center">
                    {!! Theme::partial('header.items.language-switcher') !!}
                    {!! Theme::partial('header.items.currency-switcher') !!}
                </div>
                <div class="btn-area">
                    {!! Theme::partial('header.items.login') !!}
                </div>
            </div>
        </div>
    </div>
</div>
