<div class="shortcode-about-information shortcode-about-information-style-2 about2-section-area sp1"
    @style($variablesStyle)
>
    <img src="{{ Theme::asset()->url('images/shapes/elements13.png') }}" alt="shape" class="elements12" />
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <div class="about-images-area">
                    <img src="{{ Theme::asset()->url('images/shapes/elements14.png') }}" alt="shape" class="elements14" />
                    <div class="row align-items-center">
                        @if ($image = $shortcode->image)
                            <div class="col-lg-6 col-md-6">
                                <div class="img1 image-anime reveal">
                                    {{ RvMedia::image($image, 'image') }}
                                </div>
                                <div class="space24 d-md-none d-block"></div>
                            </div>
                        @endif

                        @php
                            $image1 = $shortcode->image_1;
                            $image2 = $shortcode->image_2;
                        @endphp

                        @if($image1 || $image2)
                            <div class="col-lg-6 col-md-6">
                                @if($image1)
                                    <div class="img1 image-anime reveal">
                                        {{ RvMedia::image($image1, 'image1') }}
                                    </div>
                                @endif

                                @if ($image2)
                                    <div class="space24"></div>
                                    <div class="img1 image-anime reveal">
                                        {{ RvMedia::image($image2, 'image2') }}
                                    </div>
                                @endif
                            </div>
                        @endif
                    </div>
                </div>
            </div>
            <div class="col-lg-1"></div>
            <div class="col-lg-5">
                <div class="about2-header heading4">
                    @if ($subtitle = $shortcode->subtitle)
                        <h5 data-aos="fade-left" data-aos-duration="800">{!! BaseHelper::clean($subtitle) !!}</h5>
                    @endif

                    @if ($title = $shortcode->title)
                        <div class="space18"></div>
                        <h2 class="text-anime-style-3">{!! BaseHelper::clean($title) !!}</h2>
                    @endif

                    @if ($description = $shortcode->description)
                        <div class="space16"></div>
                        <p data-aos="fade-left" data-aos-duration="900">{!! BaseHelper::clean($description) !!}</p>
                    @endif

                    @if(count($tabs) > 0)
                        <div class="others-boxarea" data-aos="fade-left" data-aos-duration="1000">
                            @foreach($tabs as $tab)
                                @continue(! ($tabTitle = Arr::get($tab, 'title')))

                                @php
                                    $figure = Arr::get($tab, 'figure');

                                    if ((int) $figure >= 1000) {
                                        $trimmedFigure = (int) ($figure / 1000);
                                        $symbol = 'K+';
                                    } else {
                                        $trimmedFigure = $figure;
                                        $symbol = '+';
                                    }
                                @endphp

                                <div class="icons-box">
                                    @if ($icon = Arr::get($tab, 'icon'))
                                        <div class="icons flex-shrink-0">
                                            <x-core::icon :name="$icon"/>
                                        </div>
                                    @endif
                                    <p><span class="odometer" @if($trimmedFigure) data-count="{{ $trimmedFigure }}" @endif></span>{{ $symbol }} {!! BaseHelper::clean($tabTitle) !!}</p>
                                </div>
                            @endforeach
                        </div>
                    @endif

                    @if (($buttonLabel = $shortcode->button_label) && ($buttonUrl = $shortcode->button_url))
                        <div class="space32"></div>
                        <div class="btn-area1" data-aos="fade-left" data-aos-duration="1200">
                            <a href="{{ $buttonUrl }}" class="vl-btn2">
                                <span class="demo">{!! BaseHelper::clean($buttonLabel) !!}</span>
                                <span class="arrow"><x-core::icon name="ti ti-arrow-right"/>
                                </span>
                            </a>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
