<div
    class="about7-section-area sp1 shortcode-about-information shortcode-about-information-style-7" @style($variablesStyle)>
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <div class="about-header-area heading10">
                    @if ($title = $shortcode->title)
                        <h2 class="text-anime-style-3">{!! BaseHelper::clean($title) !!}</h2>
                    @endif

                    @if ($description = $shortcode->description)
                        <div class="space16"></div>
                        <p data-aos="fade-left" data-aos-duration="900">{!! BaseHelper::clean($description) !!}</p>
                    @endif

                    <div class="space32"></div>

                    @foreach($tabs as $tab)
                        @continue(! $tabTitle = Arr::get($tab, 'title'))

                        @php
                            $tabIcon = Arr::get($tab, 'icon');
                            $tabIconImage = Arr::get($tab, 'icon_image');
                        @endphp
                        <div class="about-auhtor-box" data-aos="fade-left"
                             data-aos-duration="{{ 1000 + ($loop->index * 100) }}">
                            @if($tabIconImage || $tabIcon)
                                <div class="icons">
                                    @if ($tabIconImage)
                                        {{ RvMedia::image($tabIconImage, 'icon') }}
                                    @else
                                        <x-core::icon :name="$tabIcon" />
                                    @endif
                                </div>
                            @endif

                            <div class="text">
                                <a href="#">{!! BaseHelper::clean($tabTitle) !!}</a>

                                @if ($tabDescription = Arr::get($tab, 'description'))
                                    <div class="space12"></div>
                                    <p>{!! BaseHelper::clean($tabDescription) !!}</p>
                                @endif
                            </div>
                        </div>
                        @if (! $loop->last)
                            <div class="space20"></div>
                        @endif
                    @endforeach

                    @if (($buttonLabel = $shortcode->button_label) && ($buttonUrl = $shortcode->button_url))
                        <div class="space32"></div>
                        <div class="btn-area1" data-aos="fade-left" data-aos-duration="1200">
                            <a href="{{ $buttonUrl }}" class="vl-btn7">{!! BaseHelper::clean($buttonLabel) !!}
                                <span><x-core::icon name="ti ti-arrow-right"/></span>
                            </a>
                        </div>
                    @endif
                </div>
            </div>
            <div class="col-lg-6">
                <div class="about-all-images">
                    @if ($image = $shortcode->image)
                        <div class="img1 image-anime reveal">
                            {{ RvMedia::image($image, 'contact image') }}
                        </div>
                    @endif

                    @if ($image1 = $shortcode->image_1)
                        <div class="img2 image-anime reveal">
                            {{ RvMedia::image($image1, 'contact image 1') }}
                        </div>
                    @endif
                    @if($circleText = $shortcode->circle_text)
                        <div class="arrow-btn">
                            <a href="#">
                                <div class="content" bis_skin_checked="1">
                                    <h6 class="circle rotateme">{!! BaseHelper::clean($circleText) !!}</h6>
                                </div>
                                <img src="{{ Theme::asset()->url('images/icons/arrow1.svg') }}" alt="" class="arrow1">
                            </a>
                        </div>
                    @endif

                    @if ($shapeImage = $shortcode->shape_image)
                        {{ RvMedia::image($shapeImage, 'shape image',attributes: ['class' => 'elements37']) }}
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
