@php
    $postMetaData = json_decode(theme_option('blog_post_meta_display', []), true);
    $shouldDisplayDateTime = in_array('published_date', $postMetaData);
    $shouldDisplayAuthor = in_array('author_name', $postMetaData);
    $shouldDisplayView = in_array('view_count', $postMetaData);
@endphp

<div class="blog7-section-area sp2 shortcode-blog-posts shortcode-blog-posts-style-3" @style($variablesStyle)>
    <div class="container">
        @if ($title = $shortcode->title)
            <div class="row">
                <div class="col-lg-6 m-auto">
                    <div class="blog-header text-center heading10 space-margin60">
                        <h2 class="text-anime-style-3">{!! BaseHelper::clean($title) !!}</h2>
                    </div>
                </div>
            </div>
        @endif
        <div class="row">
            @foreach($posts as $post)
                <div class="col-lg-4 col-md-6" data-aos="zoom-in" data-aos-duration="{{ 800 + ($loop->index * 200) }}">
                    <div class="blog1-auhtor-boxarea">
                        <div class="img1 image-anime">
                            {{ RvMedia::image($post->image, $post->name, 'medium-rectangle-vertical') }}
                        </div>

                        <div class="content-area">
                            <ul>
                                @if (($publishedDate = $post->created_at) && $shouldDisplayDateTime)
                                    <li>
                                    <span>
                                        @if ($calenderIcon = theme_option('calender_icon_image'))
                                            {{ RvMedia::image($calenderIcon, 'calender icon', attributes: ['style' => 'width: 20px']) }}
                                        @endif
                                        {{ $publishedDate->format('d M Y') }} <span class="symbol-slash"> | </span>
                                    </span>
                                    </li>
                                @endif
                                @if (($author = $post->author) && $shouldDisplayAuthor)
                                    @php
                                        $fullName = $author->first_name . ' ' . $author->last_name;
                                    @endphp
                                    <li>
                                        <span>
                                            @if ($authorIcon = theme_option('author_icon_image'))
                                                {{ RvMedia::image($authorIcon, 'author icon') }}
                                            @endif
                                            {!! BaseHelper::clean($fullName) !!}
                                            <span class="symbol-slash"> | </span>
                                        </span>
                                    </li>
                                @endif
                                @if (($views = $post->views) && $shouldDisplayView)
                                    <li>
                                    <span>
                                        @if ($viewIcon = theme_option('views_icon_image'))
                                            {{ RvMedia::image($viewIcon, 'view icon') }}
                                        @endif
                                        {!! BaseHelper::clean($views) !!}
                                        <span class="symbol-slash"> | </span>
                                    </span>

                                    </li>
                                @endif
                            </ul>

                            <div class="space20"></div>
                            <a aria-label="{{ $post->name }}" href="{{ $post->url }}" title="{{ $post->name }}"
                               class="truncate-2-custom">{{ $post->name }}</a>
                            <div class="space24"></div>
                            <div class="btn-area1">
                                <a aria-label="{{ __('Read Now') }}" href="{{ $post->url }}" class="vl-btn7"> {{ __('Read Now') }} <span><x-core::icon name="ti ti-arrow-right"/></span></a>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</div>
