<div
    class="contact4-section-area shortcode-contact-information-3 sp1 shortcode-contact-information shortcode-contact-information-style-3" @style($variablesStyle)>
    <div class="container">
        <div class="row">
            <div class="col-lg-6" data-aos="zoom-in" data-aos-duration="1000">
                <div class="contact4-boxarea">
                    <h3 class="text-anime-style-3">{{ __('Leave A Message') }}</h3>
                    <div class="space8"></div>

                    @if (isset($form))
                        {!! $form->renderForm() !!}
                    @endif
                </div>
            </div>
            <div class="col-lg-6">
                <div class="contact4-header heading7">
                    @if($subtitle = $shortcode->subtitle)
                        <h5 data-aos="fade-left" data-aos-duration="800">{{ BaseHelper::clean($subtitle) }}</h5>
                    @endif
                    <div class="space18"></div>
                    @if($title = $shortcode->title)
                        <h2 class="text-anime-style-3">{{ BaseHelper::clean($title) }}</h2>
                    @endif
                    <div class="space18"></div>
                    @if($description = $shortcode->description)
                        <p data-aos="fade-left" data-aos-duration="900">{{ BaseHelper::clean($description) }}</p>
                    @endif
                    <div class="space12"></div>
                    @foreach ($contactMethod as $key => $method)
                        @continue(!($title = Arr::get($method, 'title')))
                        <div class="contact-author-box" data-aos="fade-left" data-aos-duration="1100">
                            <div class="icons">
                                @if ($iconImage = Arr::get($method, 'icon_image'))
                                    {{ RvMedia::image($iconImage, 'icon') }}
                                @endif
                            </div>
                            <div class="text">
                                <h4>{!! BaseHelper::clean($title) !!}</h4>
                                <div class="space10"></div>
                                @if ($description = Arr::get($method, 'description'))
                                    @if ($url = Arr::get($method, 'url'))
                                        <a aria-label="{{ $title }}" href='{{ $url }}'>{!! BaseHelper::clean($description) !!}</a>
                                    @else
                                        <span>{!! BaseHelper::clean($description) !!}</span>
                                    @endif
                                @endif
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
        <div class="space60"></div>
        <div class="row">
            @if($image = $shortcode->image)
                <div class="col-lg-3 col-md-6">
                    <div class="img1 image-anime reveal">
                        {{ RvMedia::image($image, '', 'large') }}
                    </div>
                </div>
            @endif

            @if($image = $shortcode->image_2)
                <div class="col-lg-4 col-md-6">
                    <div class="img1 image-anime reveal">
                        {{ RvMedia::image($image, '', 'large') }}
                    </div>
                </div>
            @endif
            @if ($address = $shortcode->address)
                <div class="col-lg-5" data-aos-duration="1000">
                    <div class="mapouter">
                        <div class="gmap_canvas">
                            <iframe
                                title="{{ $address }}"
                                src="https://maps.google.com/maps?q={{ addslashes($address) }}&t=&z=13&ie=UTF8&iwloc=&output=embed"
                                width="600"
                                height="650"
                                style="border: 0"
                                allowfullscreen=""
                                loading="lazy"
                                referrerpolicy="no-referrer-when-downgrade"
                            ></iframe>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>
</div>
