@php
    $style = $shortcode->style;
    $style = in_array($style, range(1, 3)) ? $style : 1;

    $bgColor = $shortcode->background_color;
    $textColor = $shortcode->text_color;
    $bgImage = $shortcode->background_image ? RvMedia::getImageUrl($shortcode->background_image) : null;

    $variablesStyle = [];

    if ($textColor && $textColor !== 'transparent') {
        $variablesStyle["--shortcode-text-color: $textColor"] = $textColor;
    }
    if ($bgColor !== 'transparent') {
        $variablesStyle["--shortcode-background-color: $bgColor"] = $bgColor;
    }
    if ($bgImage) {
        $variablesStyle["--shortcode-background-image: url($bgImage)"] = $bgImage;
    }

    $primaryButtonLabel = $shortcode->primary_button_label;
    $primaryButtonUrl = $shortcode->primary_button_url;

    $secondaryButtonLabel = $shortcode->secondary_button_label;
    $secondaryButtonUrl = $shortcode->secondary_button_url;

    $title = $shortcode->title;
    $subtitle = $shortcode->subtitle;

    $addSpacing =
        (($title || $subtitle) && ($primaryButtonLabel && $primaryButtonUrl)) ||
        ($secondaryButtonLabel && $secondaryButtonUrl);
@endphp

{!! Theme::partial('shortcodes.countdown.styles.style-' . $style, compact('shortcode', 'variablesStyle', 'addSpacing', 'primaryButtonLabel', 'primaryButtonUrl', 'secondaryButtonLabel', 'secondaryButtonUrl', 'title', 'subtitle')) !!}
