<div class="shortcode-events-schedule shortcode-events-schedule-style-1 event1-section-area sp1"
    @style($variablesStyle)
>
    <div class="container">
        <div class="row">
            <div class="col-lg-6 m-auto">
                <div class="event-header heading2 space-margin60 text-center">
                    @if ($subtitle = $shortcode->subtitle)
                        <h5 data-aos="fade-left" data-aos-duration="800">{!! BaseHelper::clean($subtitle) !!}</h5>
                        <div class="space16"></div>
                    @endif

                    @if($title = $shortcode->title)
                        <h2 class="text-anime-style-3">{!! BaseHelper::clean($title) !!}</h2>
                    @endif
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-12">
                @if($tabs)
                    <div data-aos="fade-up" data-aos-duration="900">
                        <ul class="nav nav-pills space-margin60" role="tablist">
                            @foreach($tabs as $item)
                                <li class="nav-item" role="presentation">
                                    <button
                                        data-bb-toggle="events-schedule"
                                        data-date="{{ Arr::get($item, 'date') }}"
                                        @class(['nav-link', 'active' => $loop->first]) data-bs-toggle="pill" type="button" role="tab" aria-selected="true">
                                        <span class="day">{{ __('Day :number', ['number' => $loop->index + 1]) }}</span>
                                        <span class="vl-flex">
											<span class="cal">{{ Arr::get($item, 'day') }}</span>
											<span class="date">{{ Arr::get($item, 'month') }} <br />
												{{ Arr::get($item, 'year') }}
                                            </span>
										</span>
                                    </button>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <div class="tab-content">
                    <div class="tab-pane fade show active" role="tabpanel" aria-labelledby="pills-home-tab" tabindex="0">
                        @foreach($events as $event)
                            <div
                                data-bb-value="events-schedule"
                                data-date="{{ $event->started_at?->format('Y-m-d') }}"
                                class="tabs-widget-boxarea"
                            >
                                <div class="row align-items-center">
                                    <div class="col-lg-4">
                                        <div class="img1">
                                            {{ RvMedia::image($event->image, $event->name, 'small-rectangle') }}
                                        </div>
                                    </div>
                                    <div class="col-lg-8">
                                        <div class="content-area">
                                            <ul>
                                                <li>
                                                    <a href="{{ $event->url }}">
                                                        <img src="{{ Theme::asset()->url('images/icons/clock.svg') }}" alt="icon" />
                                                        {{ $event->started_at?->format('H:i') }} - {{ $event->ended_at?->format('H:i') }}
                                                        <span> | </span>
                                                    </a>
                                                </li>
                                                <li>
                                                    <a href="{{ $event->url }}">
                                                        <img src="{{ Theme::asset()->url('images/icons/location.svg') }}" alt="icon" /> {{ $event->address }}
                                                    </a>
                                                </li>
                                            </ul>
                                            <div class="space20"></div>
                                            <a href="{{ $event->url }}" class="head">{{ $event->name }}</a>
                                            @if ($description = $event->description)
                                                <div class="space16"></div>
                                                <p>{!! BaseHelper::clean($description) !!}</p>
                                            @endif

                                            <div class="space32"></div>
                                            <div class="btn-area1">
                                                <a href="{{ $event->url }}" class="vl-btn1">{{ __('Purchase ticket now') }}</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
