<div
    class="event4-section-area sp1 shortcode-events-schedule shortcode-events-schedule-style-3" @style($variablesStyle)>
    <div class="container">
        <div class="row">
            <div class="col-lg-5">
                <div class="event-images-area" data-aos="zoom-in" data-aos-duration="1000">
                    <div class="img1">
                        @if ($image = $shortcode->image)
                            {{ RvMedia::image($image, isset($event) ? $event->name : '' , 'small-rectangle') }}
                        @endif
                    </div>
                    <div class="content-area heading7">
                        @if ($subtitle = $shortcode->subtitle)
                            <h5>{!! BaseHelper::clean($subtitle) !!}</h5>
                        @endif
                        <div class="space18"></div>
                        @if ($title = $shortcode->title)
                            <h2>{!! BaseHelper::clean($title) !!}</h2>
                        @endif

                        @if (($buttonLabel = $shortcode->button_label) && ($buttonUrl = $shortcode->button_url))
                            <div class="space32"></div>
                            <div class="btn-area1">
                                <a href="{{ $buttonUrl }}" class="vl-btn4">{!! BaseHelper::clean($buttonLabel) !!}</a>
                            </div>
                        @endif
                    </div>
                </div>
            </div>

            <div class="col-lg-2">
                <div data-aos="fade-up" data-aos-duration="900">
                    <ul class="nav nav-pills space-margin60" id="pills-tab" role="tablist">
                        @foreach ($tabs as $tab)
                            <li class="nav-item" role="presentation">
                                <button class="nav-link @if ($loop->first) active @endif"
                                        id="pills-{{$tab['date']}}-tab" data-bs-toggle="pill"
                                        data-bs-target="#pills-{{$tab['date']}}" type="button" role="tab"
                                        aria-controls="pills-{{$tab['date']}}" aria-selected="true">
                                    <span class="day">{{__('Day :number', ['number' => $loop->index + 1])}}</span>
                                    <span class="vl-flex">
                                        <span class="cal">{{$tab['day']}}</span>
                                        <span class="date"
                                        >{{$tab['month']}} <br />
                                            {{$tab['year']}}</span
                                        >
                                    </span>
                                </button>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>

            <div class="col-lg-5" data-aos="fade-left" data-aos-duration="1200">
                <div class="tab-content" id="pills-tabContent">
                    @foreach ($tabs as $tab)
                        <div class="tab-pane fade {{$loop->first ? 'show active' : ''}}" id="pills-{{$tab['date']}}"
                             role="tabpanel" aria-labelledby="pills-{{$tab['date']}}-tab" tabindex="0">
                            <div class="accordion" id="accordion-{{$tab['date']}}">
                                @foreach ($tab['events'] as $event)
                                    <div class="accordion-item">
                                        <h2 class="accordion-header">
                                            <button class="accordion-button collapsed" type="button"
                                                    data-bs-toggle="collapse" data-bs-target="#collapse{{$event->id}}"
                                                    aria-expanded="false" aria-controls="collapse{{$event->id}}">
                                                <span><img src="{{ Theme::asset()->url('images/icons/clock.svg') }}"
                                                           alt="icon" />{{ $event->started_at?->format('H:i A') }} - {{ $event->ended_at?->format('H:i A (Y-m-d)') }}</span>
                                                <span class="accor-btn">{{$event->name}}</span>
                                            </button>
                                        </h2>
                                        @if($shortDescription = $event->short_description)
                                            <div id="collapse{{$event->id}}" class="accordion-collapse collapse"
                                                 data-bs-parent="#accordion-{{$tab['date']}}">
                                                <div class="accordion-body">
                                                    <p>{{$shortDescription}}</p>
                                                </div>
                                            </div>
                                        @endif
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>
