<div
    class="event7-section-area sp1 shortcode-events-schedule shortcode-events-schedule-style-4" @style($variablesStyle)>
    <div class="container">
        @if ($title = $shortcode->title)
            <div class="row">
                <div class="col-lg-6 m-auto">
                    <div class="event-header heading10 space-margin60 text-center">
                        <h2 class="text-anime-style-3">{!! BaseHelper::clean($title) !!}</h2>
                    </div>
                </div>
            </div>
        @endif

        <div class="row">
            <div class="col-lg-12">
                <div data-aos="fade-up" data-aos-duration="900">
                    <ul class="nav nav-pills space-margin60" id="pills-tab" role="tablist">
                        @foreach ($tabs as $tab)
                            <li class="nav-item" role="presentation">
                                <button class="nav-link @if ($loop->first) active @endif"
                                        id="pills-{{$tab['date']}}-tab" data-bs-toggle="pill"
                                        data-bs-target="#pills-{{$tab['date']}}" type="button" role="tab"
                                        aria-controls="pills-{{$tab['date']}}" aria-selected="true">
                                    <span class="day">{{__('Day :number', ['number' => $loop->index + 1])}}</span>
                                    <span class="vl-flex">
                                        <span class="cal">{{$tab['day']}}</span>
                                        <span class="date"
                                        >{{$tab['month']}} <br />
                                            {{$tab['year']}}</span
                                        >
                                    </span>
                                </button>
                            </li>
                        @endforeach
                    </ul>
                </div>

                <div class="tab-content" id="pills-tabContent">
                    @foreach ($tabs as $tab)
                        <div @class(['tab-pane fade', 'show active' => $loop->first]) id="pills-{{ $tab['date'] }}"
                             role="tabpanel" aria-labelledby="pills-{{$tab['date']}}-tab" tabindex="0">
                            <div class="tabs-widget-boxarea" data-aos="fade-up" data-aos-duration="800">
                                <div class="row align-items-center">
                                    @foreach($tab['events'] as $event)
                                        <div class="col-lg-6">
                                            <div class="all-content-area">
                                                <div class="img1">
                                                    {{ RvMedia::image($event->image, $event->name, 'thumb') }}
                                                </div>
                                                <div class="content-area">
                                                    <ul>
                                                        <li>
                                                            <a href="{{ $event->url }}"><img
                                                                    src="{{ Theme::asset()->url('images/icons/clock.svg') }}"
                                                                    alt="" />{{ $event->started_at?->format('H:i') }}
                                                                - {{ $event->ended_at?->format('H:i') }} <span> | </span></a>
                                                        </li>
                                                        <li>
                                                            <a href="{{ $event->url }}"><img
                                                                    src="{{ Theme::asset()->url('images/icons/location.svg') }}"
                                                                    alt="" />{{ $event->address }}</a>
                                                        </li>
                                                    </ul>
                                                    <div class="space20"></div>
                                                    <a href="{{ $event->url }}" class="head">{{ $event->name }}</a>

                                                    @if($description = $event->description)
                                                        <div class="space16"></div>
                                                        <p>{!! BaseHelper::clean($description) !!}</p>
                                                    @endif

                                                    <div class="space32"></div>
                                                    <div class="btn-area1">
                                                        <a href="{{ $event->url }}" class="vl-btn7">
                                                            {{ __('Purchase Ticket Now') }}
                                                            <span><x-core::icon name="ti ti-arrow-right"/></span>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="space48"></div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>
