<div
    class="event8-section-area sp1 shortcode-events-schedule shortcode-events-schedule-style-5" @style($variablesStyle)>
    <div class="container">
        <div class="row">
            <div class="col-lg-10 m-auto">
                <div class="event8-header space-margin60">
                    <div class="heading11">
                        @if ($subtitle = $shortcode->subtitle)
                            <h5>{!! BaseHelper::clean($subtitle) !!}</h5>
                        @endif

                        @if ($title = $shortcode->title)
                            <div class="space18"></div>
                            <h2 class="text-anime-style-3">{!! BaseHelper::clean($title) !!}</h2>
                        @endif
                    </div>

                    <div class="tabs-button">
                        <ul class="nav nav-pills" id="pills-tab" role="tablist">
                            @foreach ($tabs as $tab)
                                <li class="nav-item" role="presentation">
                                    <button @class(['nav-link', 'active' => $loop->first])
                                            id="pills-{{$tab['date']}}-tab"
                                            data-bs-toggle="pill"
                                            data-bs-target="#pills-{{$tab['date']}}"
                                            type="button" role="tab" aria-controls="pills-{{$tab['date']}}"
                                            aria-selected="true"
                                    >
                                        <span class="calender">
                                            <img src="{{ Theme::asset()->url('images/icons/calender.svg') }}" alt="" />
                                        </span>
                                        <span class="pl-8">
                                            <span
                                                class="day">{{ __('Day :number', ['number' => $loop->index + 1]) }}</span>
                                            <span
                                                class="date">{{ Arr::get($tab, 'month') }} {{ Arr::get($tab, 'day') }}, {{ Arr::get($tab, 'year') }}</span>
                                        </span>
                                    </button>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12" data-aos="fade-up" data-aos-duration="1000">
                <div class="tab-content" id="pills-tabContent">
                    @foreach ($tabs as $tab)
                        <div @class(['tab-pane fade', 'show active' => $loop->first]) id="pills-{{ $tab['date'] }}"
                             role="tabpanel"
                             aria-labelledby="pills-{{$tab['date']}}-tab" tabindex="0">
                            <div class="event-widget-area">
                                @foreach($tab['events'] as $event)
                                    <div class="row">
                                        <div class="col-lg-10 m-auto">
                                            <div class="event2-boxarea box1">
                                                <div class="row align-items-center">
                                                    <div class="col-lg-7">
                                                        <div class="content-area">
                                                            @if($organizer = $event->organizer)
                                                                <h5>{{ $organizer->name }}</h5>
                                                            @endif

                                                            <div class="space20"></div>
                                                            <a href="{{ $event->url }}"
                                                               class="head">{{ $event->name }}</a>
                                                            <div class="space20"></div>

                                                            @if ($description = $event->description)
                                                                <p>{!! BaseHelper::clean($description) !!}</p>
                                                                <div class="space24"></div>
                                                            @endif

                                                            <div class="btn-area1">
                                                                <a href="{{ $event->url }}" class="vl-btn8">
                                                                    <span class="demo">{{ __('Buy Ticket Now') }}</span>
                                                                    <span class="arrow">
                                                                        <x-core::icon name="ti ti-arrow-right"/>
                                                                    </span>
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-lg-5">
                                                        <div class="img1">
                                                            {{ RvMedia::image($event->image, $event->name, 'small-rectangle') }}
                                                        </div>
                                                    </div>
                                                    <div class="space24"></div>
                                                    <div class="col-gl-12">
                                                        <div class="list">
                                                            <ul>
                                                                <li>
                                                                    <a href="{{ $event->url }}"><img
                                                                            src="{{ Theme::asset()->url('images/icons/clock.svg') }}"
                                                                            alt="" />{{ $event->started_at?->format('H:i') }}
                                                                        - {{ $event->ended_at?->format('H:i') }}
                                                                        <span> | </span></a>
                                                                </li>
                                                                <li>
                                                                    <a href="{{ $event->url }}"><img
                                                                            src="{{ Theme::asset()->url('images/icons/location.svg') }}"
                                                                            alt="" />{{ $event->address }}</a>
                                                                </li>
                                                            </ul>

                                                            @if ($speakers = $event->speakers)
                                                                <div class="author-area">
                                                                    <p>{{ __('Speakers:') }}</p>
                                                                    <div class="speakers-container">
                                                                        <div class="speaker-images">
                                                                            @foreach($speakers as $speaker)
                                                                                <div class="speaker-image">
                                                                                    {{ RvMedia::image($speaker->avatar, $speaker->name, 'thumb') }}
                                                                                </div>
                                                                            @endforeach
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    @if (! $loop->last)
                                        <div class="space80"></div>
                                    @else
                                        <div class="space50"></div>
                                    @endif
                                @endforeach
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>
