@php
    $variablesStyle = [];
    $style = $shortcode->style;
    $style = in_array($style, range(1, 5)) ? $style : 1;

    $bgColor = $shortcode->background_color;
    $textColor = $shortcode->text_color;
    $bgImage = $shortcode->background_image ? RvMedia::getImageUrl($shortcode->background_image) : null;

    if ($textColor && $textColor !== 'transparent') {
        $variablesStyle["--shortcode-text-color: $textColor"] = $textColor;
        $variablesStyle["--shortcode-text-color-2: $textColor"] = $textColor;
        $variablesStyle["--shortcode-text-color-3: $textColor"] = $textColor;
        $variablesStyle["--shortcode-text-color-4: $textColor"] = $textColor;
    }
    if ($bgColor !== 'transparent') {
        $variablesStyle["--shortcode-background-color: $bgColor"] = $bgColor;
    }
    if ($bgImage) {
        $variablesStyle["--shortcode-background-image: url($bgImage)"] = $bgImage;
    }
@endphp

{!! Theme::partial('shortcodes.events.styles.style-' . $style, compact('events', 'shortcode', 'variablesStyle')) !!}
