<div class="shortcode-events shortcode-events-style-3 event5-section-area sp6"
    @style($variablesStyle)
>
    <img src="{{ Theme::asset()->url('images/icons/elements28.png') }}" alt="" class="elements28" />
    <img src="{{ Theme::asset()->url('images/icons/elements29.png') }}" alt="" class="elements29" />
    <div class="container">
        <div class="row">
            <div class="col-lg-8 m-auto">
                <div class="event2-header heading8 text-center space-margin80">
                    @if ($subtitle = $shortcode->subtitle)
                        <h5>
                            @if($subtitleImage = $shortcode->subtitle_image)
                                {{ RvMedia::image($subtitleImage, '') }}
                            @endif

                            {!! BaseHelper::clean($subtitle) !!}
                        </h5>

                        <div class="space32"></div>
                    @endif

                    @if ($title = $shortcode->title)
                        <h2 class="text-anime-style-3">{!! BaseHelper::clean($title) !!}</h2>
                    @endif
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12" data-aos="fade-up" data-aos-duration="1000">
                <div class="event-widget-area">
                    @foreach($events as $event)
                        @php
                            $speakers = $event->speakers->take(2);
                        @endphp

                        <div class="row">
                            <div class="col-lg-1"></div>
                            <div class="col-lg-10 m-auto">
                                <div class="event2-boxarea box1">
                                    <h1 class="active">{{ $loop->index + 1 }}</h1>
                                    <div class="row align-items-center">
                                        @if(! $loop->even)
                                            <div class="col-lg-5">
                                                <div class="img1">
                                                    {{ RvMedia::image($event->image, $event->name, 'small-rectangle') }}
                                                </div>
                                            </div>
                                            <div class="col-lg-1"></div>
                                            <div class="col-lg-6">
                                                <div class="content-area">
                                                    <ul>
                                                        <li>
                                                            <a aria-label="{{ $event->name }}" href="{{ $event->url }}">
                                                                <img
                                                                    src="{{ Theme::asset()->url('images/icons/clock.svg') }}"
                                                                    alt="icon" />
                                                                {{ $event->started_at?->format('H:i') }}
                                                                - {{ $event->ended_at?->format('H:i') }}
                                                                <span> | </span>
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <a aria-label="{{ $event->name }}" href="{{ $event->url }}">
                                                                <img
                                                                    src="{{ Theme::asset()->url('images/icons/location.svg') }}"
                                                                    alt="icon" /> {{ $event->address }}
                                                            </a>
                                                        </li>
                                                    </ul>
                                                    <div class="space20"></div>
                                                    <a aria-label="{{ $event->name }}" href="{{ $event->url }}" class="head">{{ $event->name }}</a>
                                                    <div class="space24"></div>
                                                    @if($speakers->isNotEmpty())
                                                        <div class="space24"></div>
                                                        <div class="author-area">
                                                            @foreach($speakers as $speaker)
                                                                <div class="autho-name-area">
                                                                    <div class="img1">
                                                                        {{ RvMedia::image($speaker->avatar, $speaker->name, 'thumb') }}
                                                                    </div>
                                                                    <div class="text">
                                                                        <a aria-label="{{ $speaker->name }}" href="{{ $speaker->url }}">{{ $speaker->name }}</a>
                                                                        @if ($speakerTitle = $speaker->getMetaData('title', true))
                                                                            <div class="space8"></div>
                                                                            <p>{!! BaseHelper::clean($speakerTitle) !!}</p>
                                                                        @endif
                                                                    </div>
                                                                </div>
                                                            @endforeach
                                                        </div>
                                                        <div class="space24"></div>
                                                    @endif
                                                    <div class="space24"></div>
                                                    <div class="btn-area1">
                                                        <a aria-label="{{ $event->name }}" href="{{ $event->url }}" class="vl-btn5"
                                                        ><span class="demo">{{ __('Buy ticket') }}</span><span
                                                                class="arrow">
                                                                <x-core::icon name="ti ti-arrow-right"/>
                                                            </span
                                                            ></a>
                                                    </div>
                                                </div>
                                            </div>
                                        @else
                                            <div class="col-lg-6">
                                                <div class="content-area">
                                                    <ul>
                                                        <li>
                                                            <a aria-label="{{ $event->name }}" href="{{ $event->url }}">
                                                                <img
                                                                    src="{{ Theme::asset()->url('images/icons/clock.svg') }}"
                                                                    alt="icon" />
                                                                {{ $event->started_at?->format('H:i') }}
                                                                - {{ $event->ended_at?->format('H:i') }}
                                                                <span> | </span>
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <a aria-label="{{ $event->name }}" href="{{ $event->url }}">
                                                                <img
                                                                    src="{{ Theme::asset()->url('images/icons/location.svg') }}"
                                                                    alt="icon" /> {{ $event->address }}
                                                            </a>
                                                        </li>
                                                    </ul>
                                                    <div class="space20"></div>
                                                    <a aria-label="{{ $event->name }}" href="{{ $event->url }}" class="head">{{ $event->name }}</a>
                                                    <div class="space24"></div>
                                                    @if($speakers->isNotEmpty())
                                                        <div class="space24"></div>
                                                        <div class="author-area">
                                                            @foreach($speakers as $speaker)
                                                                <div class="autho-name-area">
                                                                    <div class="img1">
                                                                        {{ RvMedia::image($speaker->avatar, $speaker->name, 'thumb') }}
                                                                    </div>
                                                                    <div class="text">
                                                                        <a aria-label="{{ $speaker->name }}" href="{{ $speaker->url }}">{{ $speaker->name }}</a>
                                                                        @if ($speakerTitle = $speaker->getMetaData('title', true))
                                                                            <div class="space8"></div>
                                                                            <p>{!! BaseHelper::clean($speakerTitle) !!}</p>
                                                                        @endif
                                                                    </div>
                                                                </div>
                                                            @endforeach
                                                        </div>
                                                        <div class="space24"></div>
                                                    @endif
                                                    <div class="space24"></div>
                                                    <div class="btn-area1">
                                                        <a aria-label="{{ $event->name }}" href="{{ $event->url }}" class="vl-btn5"
                                                        ><span class="demo">{{ __('Buy ticket') }}</span><span
                                                                class="arrow">
                                                                <x-core::icon name="ti ti-arrow-right"/>
                                                            </span
                                                            ></a>
                                                    </div>
                                                </div>
                                                <div class="space30 d-lg-none d-block"></div>
                                            </div>
                                            <div class="col-lg-5">
                                                <div class="img1">
                                                    {{ RvMedia::image($event->image, $event->name, 'small-rectangle') }}
                                                </div>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="space48"></div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>
