<div class="shortcode-hero-banner shortcode-hero-banner-style-3 hero4-section-area"
    @style($variablesStyle)
>
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-5">
                <div class="hero4-header">
                    @if($subtitle = $shortcode->subtitle)
                        <h5 data-aos="fade-left" data-aos-duration="800">
                            @if($subtitle_image = $shortcode->subtitle_image)
                                {{ RvMedia::image($subtitle_image, '', 'thumbnail', attributes: ['class' => 'd-md-inline-block d-none']) }}
                            @endif

                            {!! BaseHelper::clean($subtitle) !!}
                        </h5>
                    @endif

                    @if ($title = $shortcode->title)
                        <div class="space20"></div>
                        <h1 class="text-anime-style-3">{!! BaseHelper::clean($title) !!}</h1>
                    @endif

                    @if($description = $shortcode->description)
                        <div class="space20"></div>
                        <p data-aos="fade-left" data-aos-duration="900">
                            {!! BaseHelper::clean($description) !!}
                        </p>
                    @endif

                    @if (($buttonPrimaryLabel = $shortcode->button_primary_label) && ($buttonPrimaryUrl = $shortcode->button_primary_url))
                        <div class="space32"></div>
                        <div class="btn-area1" data-aos="fade-left" data-aos-duration="1000">
                            <a href="{{ $buttonPrimaryUrl }}" class="vl-btn4">{{ $buttonPrimaryLabel }}</a>
                        </div>
                    @endif

                </div>
            </div>
            <div class="col-lg-2"></div>
            @if($event)
                <div class="col-lg-5">
                    <div class="hero-content-images">
                        <div class="img1 reveal image-anime">
                            @if($image = $shortcode->image)
                                {{ RvMedia::image($image, $shortcode->title) }}
                            @endif
                        </div>
                        <div class="content-area aniamtion-key-1">
                            @if($image = $event->image)
                                <div class="img2 image-anime reveal">
                                    {{ RvMedia::image($image, $event->name, 'thumbnail', attributes: ['style' => 'width: 230px']) }}
                                </div>
                            @endif
                            @if($startedDate = $event->started_at?->format('d M, Y'))
                                <div class="space16"></div>
                                <span class="date">{{ $startedDate }}</span>
                            @endif
                            <ul>
                                @if($event->started_at && $event->ended_at)
                                    <li>
                                    <span>
                                        @if($timeImage = theme_option('event_list_widget_date_icon_image'))
                                            {{ RvMedia::image($timeImage, '', 'thumbnail', attributes: ['style' => 'width: 20px']) }}
                                        @endif
                                        {{ $event->started_at?->format('H:i') }} - {{ $event->ended_at?->format('H:i') }}
                                    </span>
                                    </li>
                                @endif
                                @if($address = $event->address)
                                    <li>
                                    <span>
                                        @if($locationImage = theme_option('event_location_image'))
                                            {{ RvMedia::image($locationImage, '', 'thumbnail', attributes: ['style' => 'width: 20px']) }}
                                        @endif
                                        {{ $address }}
                                    </span>
                                    </li>
                                @endif
                            </ul>
                            <div class="space24"></div>
                            <div class="btn-area1">
                                <a href="{{ $event->url }}" class="vl-btn4">{{ __('Buy ticket') }}</a>
                            </div>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>
</div>
