<div class="hero9-slider-area shortcode-hero-banner shortcode-hero-banner-style-8" @style($variablesStyle)>
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-7">
                <div class="hero8-header">
                    @if ($subtitle = $shortcode->subtitle)
                        <h5>
                            @if($subtitleImage = $shortcode->subtitle_image)
                                {{ RvMedia::image($subtitleImage, 'subtitle image', 'thumbnail', attributes: ['class' => 'subtitle-img d-md-inline-block d-none']) }}
                            @endif

                            {!! BaseHelper::clean($subtitle) !!}
                        </h5>
                    @endif

                    @if ($title = $shortcode->title)
                        <div class="space16"></div>
                        <h1 class="text-anime-style-3">{!! BaseHelper::clean($title) !!}</h1>
                    @endif

                    @php
                        $buttonPrimaryLabel = $shortcode->button_primary_label;
                        $buttonPrimaryUrl = $shortcode->button_primary_url;
                        $buttonSecondaryLabel = $shortcode->button_secondary_label;
                        $buttonSecondaryUrl = $shortcode->button_secondary_url;
                    @endphp

                    @if (($buttonPrimaryLabel && $buttonPrimaryUrl) || ($buttonSecondaryLabel && $buttonSecondaryUrl))
                        <div class="space32"></div>
                        <div class="btn-area1">
                            @if($buttonPrimaryLabel && $buttonPrimaryUrl)
                                <a href="{{ $buttonPrimaryUrl }}" class="vl-btn9"><span
                                        class="demo">{!! BaseHelper::clean($buttonPrimaryLabel) !!}</span></a>
                            @endif

                            @if ($buttonSecondaryLabel && $buttonSecondaryUrl)
                                <a href="{{ $buttonSecondaryUrl }}" class="vl-btn9 btn2"><span
                                        class="demo">{!! BaseHelper::clean($buttonSecondaryLabel) !!}</span></a>
                            @endif
                        </div>
                    @endif
                </div>
            </div>

            @if ($image = $shortcode->image)
                <div class="col-lg-5">
                    <div class="img1">
                        {{ RvMedia::image($image,'image 1') }}
                    </div>
                </div>
            @endif
        </div>

        @if($event)
            <div class="row">
                <div class="col-lg-12">
                    <div class="timer-bg-area">
                        <div class="row">
                            <div class="col-lg-7">
                                <div class="timer-btn-area">
                                    <div class="timer" data-target="{{ $event->started_at }}">
                                        <div class="time-box">
                                            <span class="time-value days"></span>
                                            <br />
                                        </div>
                                        <div class="space14"></div>
                                        <div class="time-box">
                                            <span class="time-value hours"></span>
                                            <br />
                                        </div>
                                        <div class="space14"></div>
                                        <div class="time-box">
                                            <span class="time-value minutes"></span>
                                            <br />
                                        </div>
                                        <div class="space14"></div>
                                        <div class="time-box box2">
                                            <span class="time-value seconds"></span>
                                            <br />
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-5">
                                <div class="heading12">
                                    <h3>{{ $event->started_at?->format('d F Y') }}</h3>
                                    <div class="space16"></div>
                                    <p>
                                        <x-core::icon name="ti ti-map-pin" />
                                        {{ $event->address }}
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif

    </div>
</div>
