@php
    $bgColor = $shortcode->background_color;
    $textColor = $shortcode->text_color;
    $bgImage = $shortcode->background_image ? RvMedia::getImageUrl($shortcode->background_image) : null;

    $variablesStyle = [
        "--shortcode-text-color: $textColor" => $textColor,
        "--shortcode-background-color: $bgColor" => $bgColor,
        "--shortcode-background-image: url($bgImage)" => $bgImage,
    ];
@endphp

<div class="vanue-section-area sp2 shortcode-locations" @style($variablesStyle)>
    <div class="container">
        @if ($title = $shortcode->title)
            <div class="row">
                <div class="col-lg-5 m-auto">
                    <div class="vanue-header heading10 text-center space-margin60">
                        <h2 class="text-anime-style-3">{!! BaseHelper::clean($title) !!}</h2>
                    </div>
                </div>
            </div>
        @endif

        <div class="row">
            @foreach($tabs as $tab)
                @continue(! $tabName = Arr::get($tab, 'name'))
                <div class="col-lg-3 col-md-6" data-aos="zoom-in" data-aos-duration="{{ 900 + ($loop->index * 100) }}">
                    <div class="vanue-single-item-area">
                        @if ($tabImage = Arr::get($tab, 'image'))
                            <div class="img1 image-anime">
                                {{ RvMedia::image($tabImage, 'tab image') }}
                            </div>
                        @endif

                        <div class="content-area">
                            @if ($tabSubtitle = Arr::get($tab, 'subtitle'))
                                <span>{!! BaseHelper::clean($tabSubtitle) !!}</span>
                                <div class="space16"></div>
                            @endif


                            <a href="#">{!! BaseHelper::clean($tabName) !!}</a>

                            @if ($address = Arr::get($tab, 'address'))
                                <div class="space12"></div>
                                <p>{!! BaseHelper::clean($address) !!}</p>
                            @endif

                            @if (($buttonLabel = Arr::get($tab, 'button_label')) && ($buttonUrl = Arr::get($tab, 'button_url')))
                                <div class="space16"></div>
                                <a href="{{ $buttonUrl }}" class="tour">{!! BaseHelper::clean($buttonLabel) !!}
                                    <x-core::icon name="ti ti-arrow-right"/>
                                </a>
                            @endif
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</div>
