<div class="others-pricing-area sp2 shortcode-pricing shortcode-pricing-style-3" @style($variablesStyle)>
    <div class="container">
        <div class="row">
            <div class="col-lg-6 m-auto">
                <div class="pricing-heading heading9 text-center space-margin60">
                    @if ($subtitle = $shortcode->subtitle)
                        <h5>
                            @if ($subtitleImage = $shortcode->subtitle_image)
                                {{ RvMedia::image($subtitleImage, 'icon', attributes: ['class' => 'subtitle-img']) }}
                            @endif

                            {!! BaseHelper::clean($subtitle) !!}
                        </h5>
                    @endif

                    @if ($title = $shortcode->title)
                        <div class="space20"></div>
                        <h2 class="text-anime-style-3">{!! BaseHelper::clean($title) !!}</h2>
                    @endif
                </div>
            </div>
        </div>

        @if(count($tabs) > 0)
            <div class="row">
                @foreach ($tabs as $tab)
                    @php
                        $bgColor = Arr::get($tab, 'background_color');
                        $bgColor = $bgColor === 'transparent' ? null : $bgColor;
                        $styles = [
                            "background-color: $bgColor !important" => $bgColor,
                        ];
                    @endphp

                    @continue(! ($name = Arr::get($tab, 'name')))

                    <div class="col-lg-6 col-md-6" data-aos="fade-right" data-aos-duration="1000">
                        <div class="pricing-boarea" @style($styles)>
                            <h3>{!! BaseHelper::clean($name) !!}</h3>

                            @if ($tabDescription = Arr::get($tab, 'description'))
                                <div class="space24"></div>
                                <p>{!! BaseHelper::clean($tabDescription) !!}</p>
                            @endif

                            @if ($price = Arr::get($tab, 'price'))
                                <div class="space32"></div>
                                <h2>{!! BaseHelper::clean($price) !!}</h2>
                            @endif

                            @if(($buttonLabel = Arr::get($tab, 'button_label')) && ($buttonUrl = Arr::get($tab, 'button_url')))
                                <div class="space40"></div>
                                <div class="btn-area1">
                                    <a href="{{ $buttonUrl }}" class="vl-btn6">
                                        {!! BaseHelper::clean($buttonLabel) !!}
                                        <img src="{{ Theme::asset()->url('images/icons/arrow2.svg') }}" alt="" />
                                    </a>
                                </div>
                            @endif

                            <div class="space40"></div>
                            <h4>{{ __('Complete Access To:') }}</h4>
                            <div class="space8"></div>
                            <ul>
                                @foreach($features = Arr::get($tab, 'features')  as $feature)
                                    <li>
                                        @if($feature['is_available'])
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                 viewBox="0 0 24 24" fill="currentColor"
                                                 class="icon icon-tabler icons-tabler-filled icon-tabler-circle-check flex-shrink-0 text-success">
                                                <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                                <path
                                                    d="M17 3.34a10 10 0 1 1 -14.995 8.984l-.005 -.324l.005 -.324a10 10 0 0 1 14.995 -8.336zm-1.293 5.953a1 1 0 0 0 -1.32 -.083l-.094 .083l-3.293 3.292l-1.293 -1.292l-.094 -.083a1 1 0 0 0 -1.403 1.403l.083 .094l2 2l.094 .083a1 1 0 0 0 1.226 0l.094 -.083l4 -4l.083 -.094a1 1 0 0 0 -.083 -1.32z" />
                                            </svg>
                                        @else
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                 viewBox="0 0 24 24" fill="currentColor"
                                                 class="icon icon-tabler icons-tabler-filled icon-tabler-circle-x flex-shrink-0 text-danger">
                                                <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                                <path
                                                    d="M17 3.34a10 10 0 1 1 -14.995 8.984l-.005 -.324l.005 -.324a10 10 0 0 1 14.995 -8.336zm-6.489 5.8a1 1 0 0 0 -1.218 1.567l1.292 1.293l-1.292 1.293l-.083 .094a1 1 0 0 0 1.497 1.32l1.293 -1.292l1.293 1.292l.094 .083a1 1 0 0 0 1.32 -1.497l-1.292 -1.293l1.292 -1.293l.083 -.094a1 1 0 0 0 -1.497 -1.32l-1.293 1.292l-1.293 -1.292l-.094 -.083z" />
                                            </svg>
                                        @endif

                                        {!! BaseHelper::clean($feature['value']) !!}
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                @endforeach
            </div>
        @endif
    </div>
</div>
