@php
    $bgColor = $shortcode->background_color;
    $textColor = $shortcode->text_color;
    $bgImage = $shortcode->background_image ? RvMedia::getImageUrl($shortcode->background_image) : null;

    $variablesStyle = [];

    if ($textColor && $textColor !== 'transparent') {
        $variablesStyle["--shortcode-text-color: $textColor"] = $textColor;
    }
    if ($bgColor !== 'transparent') {
        $variablesStyle["--shortcode-background-color: $bgColor"] = $bgColor;
    }
    if ($bgImage) {
        $variablesStyle["--shortcode-background-image: url($bgImage)"] = $bgImage;
    }
@endphp

<div class="shortcode-site-statistics counter5-section-area"
    @style($variablesStyle)
>
    <div class="container">
        <div class="row">
            @foreach($tabs as $tab)
                @php
                    $title = Arr::get($tab, 'title');
                    $data = Arr::get($tab, 'data');
                @endphp

                @continue(! $data || ! $title)

                <div class="col-lg-3 col-md-6">
                    <div class="counter-box">
                        <h2>
                            <span class="odometer" data-count="{{ $data }}"></span>
                            {!! BaseHelper::clean(Arr::get($tab, 'unit')) !!}
                        </h2>
                        <p>{!! BaseHelper::clean($title) !!}</p>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</div>
